/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.catalog;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.observation.Observer;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.workspaces.initialization.CatalogPageInitializerExtensionPoint;
import org.ametys.plugins.workspaces.initialization.PageInitializer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class InitializeCatalogSitemapObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    private ObservationManager _observationManager;
    private ProfileAssignmentStorageExtensionPoint _profileAssignementStorageEP;
    private CurrentUserProvider _currentUserProvider;
    private CatalogPageInitializerExtensionPoint _catalogPageInitializerEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._catalogPageInitializerEP = (CatalogPageInitializerExtensionPoint)((Object)manager.lookup(CatalogPageInitializerExtensionPoint.ROLE));
        this._profileAssignementStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
    }

    public boolean supports(Event event) {
        if ("site.updated".equals(event.getId())) {
            Site site = (Site)event.getArguments().get("site");
            return "workspaces.catalog".equals(site.getType());
        }
        return false;
    }

    public int getPriority(Event event) {
        return 2000;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Site site = (Site)event.getArguments().get("site");
        this.initializeSitemaps(site);
    }

    private void initializeSitemaps(Site site) {
        try (AmetysObjectIterable sitemaps = site.getSitemaps();){
            for (Sitemap sitemap : sitemaps) {
                AmetysObjectIterable pages = sitemap.getChildrenPages();
                try {
                    if (pages.getSize() != 0L) continue;
                    this._setRightsOnContext(sitemap);
                    for (String initializerId : this._catalogPageInitializerEP.getExtensionsIds()) {
                        PageInitializer initializer = (PageInitializer)this._catalogPageInitializerEP.getExtension(initializerId);
                        initializer.createPage((ModifiableSitemapElement)sitemap);
                    }
                    HashMap<String, Sitemap> eventParams = new HashMap<String, Sitemap>();
                    eventParams.put("sitemap", sitemap);
                    this._observationManager.notify(new Event("sitemap.updated", this._currentUserProvider.getUser(), eventParams));
                }
                finally {
                    if (pages == null) continue;
                    pages.close();
                }
            }
        }
    }

    private void _setRightsOnContext(Sitemap sitemap) {
        this._profileAssignementStorageEP.denyProfileToAnonymous("READER", (Object)sitemap);
        this._profileAssignementStorageEP.allowProfileToAnyConnectedUser("READER", (Object)sitemap);
        sitemap.saveChanges();
        this._notifyACLChange(sitemap, Set.of("READER"));
    }

    private void _notifyACLChange(Object context, Set<String> profilesId) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", context);
        eventParams.put("acl-profiles", profilesId);
        this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
    }
}

