/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.chat;

import java.util.Map;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.chat.ChatHelper;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MemberValidatedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected ChatHelper _chatHelper;
    private ContentTypesHelper _contentTypesHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._chatHelper = (ChatHelper)((Object)manager.lookup(ChatHelper.ROLE));
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
    }

    public boolean supports(Event event) {
        if (!"content.validated".equals(event.getId()) || !((Boolean)Config.getInstance().getValue("workspaces.chat.active")).booleanValue()) {
            return false;
        }
        Content content = (Content)event.getArguments().get("content");
        return this._contentTypesHelper.isInstanceOf(content, "org.ametys.plugins.workspaces.Content.member");
    }

    public int getPriority(Event event) {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Content content = (Content)event.getArguments().get("content");
        UserIdentity user = (UserIdentity)content.getValue("user");
        if (user != null) {
            try {
                this._chatHelper.updateUserInfos(user, false);
            }
            catch (Exception e) {
                this.getLogger().debug("An error occurred while update userinfo on chat server for " + UserIdentity.userIdentityToString((UserIdentity)user), (Throwable)e);
            }
        }
    }
}

