/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.chat;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.workspaces.chat.ChatHelper;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.quartz.JobExecutionContext;

public class ServersSynchronizationSchedulable
extends AbstractStaticSchedulable {
    private ChatHelper _chatHelper;
    private ProjectManager _projectManager;
    private ProjectMemberManager _projectMemberManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._chatHelper = (ChatHelper)((Object)manager.lookup(ChatHelper.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        if (!((Boolean)Config.getInstance().getValue("workspaces.chat.active")).booleanValue()) {
            return;
        }
        ContextHelper.getRequest((Context)this._context).setAttribute("site", Config.getInstance().getValue("workspaces.catalog.site.name"));
        int errors = 0;
        HashSet<UserIdentity> handledUsers = new HashSet<UserIdentity>();
        for (String projectName : this._projectManager.getProjectNames()) {
            Project project = this._projectManager.getProject(projectName);
            try {
                this._chatHelper.getRoom(projectName, true);
                Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, true);
                List<UserIdentity> projectMemersIdentities = projectMembers.stream().map(pm -> pm.getUser().getIdentity()).collect(Collectors.toList());
                this._chatHelper.removeAllUsersFromRoom(projectName, projectMemersIdentities);
                for (UserIdentity userIdentity : projectMemersIdentities) {
                    try {
                        if (!handledUsers.contains(userIdentity)) {
                            this._chatHelper.getUser(userIdentity, true);
                            this._chatHelper.updateUserInfos(userIdentity, false);
                            handledUsers.add(userIdentity);
                        }
                        this._chatHelper.addUserToRoom(userIdentity, projectName);
                    }
                    catch (Exception e) {
                        this.getLogger().error("An error occurred when syncronizing user " + UserIdentity.userIdentityToString((UserIdentity)userIdentity) + " with project " + projectName, (Throwable)e);
                        ++errors;
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred when syncronizing project " + projectName, (Throwable)e);
                ++errors;
            }
        }
        if (errors > 0) {
            throw new IllegalStateException(errors + " errors occurred while synchronizing chat server. See previous log to know more");
        }
    }
}

