/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.favorites;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class FavoritesHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String USERPREFS_ID = "workspaces.favorites";
    public static final String ROLE = FavoritesHelper.class.getName();
    protected JSONUtils _jsonUtils;
    protected UserPreferencesManager _userPrefManager;
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected ProjectManager _projectManager;
    protected CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._userPrefManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._userPrefEP = (UserPreferencesExtensionPoint)manager.lookup(UserPreferencesExtensionPoint.ROLE + ".FO");
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public Set<String> getFavorites(UserIdentity userIdentity) {
        return new HashSet<String>(this.getPreferences(userIdentity));
    }

    @Callable
    public boolean setFavoriteProject(String projectName, boolean favorite) {
        UserIdentity user = this._currentUserProvider.getUser();
        try {
            ArrayList<String> preferences = new ArrayList<String>(this.getPreferences(user));
            if (favorite && !preferences.contains(projectName)) {
                preferences.add(projectName);
            } else if (!favorite && preferences.contains(projectName)) {
                preferences.remove(projectName);
            }
            String preferencesAsString = this._jsonUtils.convertObjectToJson(preferences);
            Map values = this._userPrefManager.getUnTypedUserPrefs(user, this._getStorageContext(), Map.of());
            values.put(USERPREFS_ID, preferencesAsString);
            this._userPrefManager.setUserPreferences(user, this._getStorageContext(), Map.of(), values);
            return true;
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Could not change favorite status of user " + UserIdentity.userIdentityToString((UserIdentity)user) + " on project " + projectName);
            return false;
        }
    }

    private List<String> getPreferences(UserIdentity userIdentity) {
        try {
            String prefAsString = this._userPrefManager.getUserPreferenceAsString(userIdentity, this._getStorageContext(), Map.of(), USERPREFS_ID);
            if (prefAsString != null) {
                return this._jsonUtils.convertJsonToList(prefAsString);
            }
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("An error occurred while reading the preferences of user " + UserIdentity.userIdentityToString((UserIdentity)userIdentity), (Throwable)e);
        }
        return List.of();
    }

    private String _getStorageContext() {
        return "/sites/" + this._projectManager.getCatalogSiteName();
    }
}

