/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ProjectAccessController
extends AbstractRightBasedAccessController
implements Serviceable {
    public static final I18nizableText WORKSPACE_CONTEXT_CATEGORY = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_ACCESS_CONTROLLER_CONTEXT_CATEGORY");
    protected ProjectManager _projectManager;
    protected ProjectMemberManager _projectMembers;
    protected SiteManager _siteManager;
    protected Set<String> _managerRights = Set.of("Plugins_Workspaces_Rights_Project_Edit", "Plugins_Workspaces_Rights_Project_Delete", "Front_Edition_Access_Right");
    protected Set<String> _memberRights = Set.of("Front_Edition_Access_Right");

    public void service(ServiceManager manager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectMembers = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public boolean isSupported(Object object) {
        return object instanceof Project;
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        ProjectMemberManager.ProjectMember projectMember;
        Project project = (Project)((Object)object);
        if (this._managerRights.contains(rightId) && ArrayUtils.contains((Object[])project.getManagers(), (Object)user)) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        if (this._memberRights.contains(rightId) && (projectMember = this._projectMembers.getProjectMember(project, user, userGroups)) != null) {
            return JCRProjectMember.MemberType.USER == projectMember.getType() ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.GROUP_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        Project project = (Project)((Object)object);
        if (ArrayUtils.contains((Object[])project.getManagers(), (Object)user)) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        ProjectMemberManager.ProjectMember projectMember = this._projectMembers.getProjectMember(project, user, userGroups);
        if (projectMember != null) {
            return JCRProjectMember.MemberType.USER == projectMember.getType() ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.GROUP_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight;
        block3: {
            Project project;
            block2: {
                permissionByRight = new HashMap<String, AccessController.AccessResult>();
                project = (Project)((Object)object);
                if (!ArrayUtils.contains((Object[])project.getManagers(), (Object)user)) break block2;
                for (String managerRight : this._managerRights) {
                    permissionByRight.put(managerRight, AccessController.AccessResult.USER_ALLOWED);
                }
                break block3;
            }
            ProjectMemberManager.ProjectMember projectMember = this._projectMembers.getProjectMember(project, user, userGroups);
            if (projectMember == null) break block3;
            for (String memberRight : this._memberRights) {
                permissionByRight.put(memberRight, JCRProjectMember.MemberType.USER == projectMember.getType() ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.GROUP_ALLOWED);
            }
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (this._managerRights.contains(rightId)) {
            Project project = (Project)((Object)object);
            for (UserIdentity manager : project.getManagers()) {
                permissionByUser.put(manager, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByUser;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        Project project = (Project)((Object)object);
        for (UserIdentity manager : project.getManagers()) {
            permissionByUser.put(manager, AccessController.AccessResult.USER_ALLOWED);
        }
        for (ProjectMemberManager.ProjectMember member : this._projectMembers.getProjectMembers(project, false)) {
            if (member.getType() != JCRProjectMember.MemberType.USER) continue;
            permissionByUser.put(member.getUser().getIdentity(), AccessController.AccessResult.USER_ALLOWED);
        }
        return permissionByUser;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Map.of();
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        HashMap<GroupIdentity, AccessController.AccessResult> permissionByGroup = new HashMap<GroupIdentity, AccessController.AccessResult>();
        Project project = (Project)((Object)object);
        for (ProjectMemberManager.ProjectMember member : this._projectMembers.getProjectMembers(project, false)) {
            if (member.getType() != JCRProjectMember.MemberType.GROUP) continue;
            permissionByGroup.put(member.getGroup().getIdentity(), AccessController.AccessResult.USER_ALLOWED);
        }
        return permissionByGroup;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public AccessExplanation explainReadAccessPermission(UserIdentity user, Set<GroupIdentity> groups, Object object) {
        AccessController.AccessResult accessResult = this.getReadAccessPermission(user, groups, object);
        switch (accessResult) {
            case USER_ALLOWED: {
                Project project = (Project)((Object)object);
                if (ArrayUtils.contains((Object[])project.getManagers(), (Object)user)) {
                    return new AccessExplanation(this.getId(), accessResult, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_MANAGER_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()))));
                }
                return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_ALLOWED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_USER_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()))));
            }
            case GROUP_ALLOWED: {
                Project project = (Project)((Object)object);
                ProjectMemberManager.ProjectMember projectMember = this._projectMembers.getProjectMember(project, user, groups);
                return new AccessExplanation(this.getId(), AccessController.AccessResult.GROUP_ALLOWED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_GROUP_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()), "group", new I18nizableText(projectMember.getGroup().getLabel()))));
            }
        }
        return this.getStandardAccessExplanation(accessResult, object);
    }

    public AccessExplanation explainPermission(UserIdentity user, Set<GroupIdentity> groups, String rightId, Object object) {
        AccessController.AccessResult accessResult = this.getPermission(user, groups, rightId, object);
        switch (accessResult) {
            case USER_ALLOWED: {
                Project project = (Project)((Object)object);
                if (this._managerRights.contains(rightId) && ArrayUtils.contains((Object[])project.getManagers(), (Object)user)) {
                    return new AccessExplanation(this.getId(), accessResult, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_MANAGER_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()))));
                }
                return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_ALLOWED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_USER_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()))));
            }
            case GROUP_ALLOWED: {
                Project project = (Project)((Object)object);
                ProjectMemberManager.ProjectMember projectMember = this._projectMembers.getProjectMember(project, user, groups);
                return new AccessExplanation(this.getId(), AccessController.AccessResult.GROUP_ALLOWED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_GROUP_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()), "group", new I18nizableText(projectMember.getGroup().getLabel()))));
            }
        }
        return this.getStandardAccessExplanation(accessResult, object);
    }

    public AccessExplanation getStandardAccessExplanation(AccessController.AccessResult accessResult, Object object) {
        switch (accessResult) {
            case USER_ALLOWED: {
                Project project = (Project)((Object)object);
                return new AccessExplanation(this.getId(), AccessController.AccessResult.USER_ALLOWED, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_USER_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()))));
            }
            case UNKNOWN: {
                Project project = (Project)((Object)object);
                return new AccessExplanation(this.getId(), accessResult, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_UNKNOWN_EXPLANATION", Map.of("title", new I18nizableText(project.getTitle()))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)accessResult);
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof Project) {
            Project project = (Project)((Object)object);
            return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_ACCESS_CONTROLLER_OBJECT_LABEL", Map.of("title", new I18nizableText(project.getTitle())));
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return WORKSPACE_CONTEXT_CATEGORY;
    }

    public int getObjectPriority(Object object) {
        return 10;
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups) {
        String siteName = WebHelper.getSiteName((Request)ContextHelper.getRequest((Context)this._context));
        Site site = this._siteManager.getSite(siteName);
        if (site != null) {
            try {
                if (StringUtils.equals((CharSequence)siteName, (CharSequence)this._projectManager.getCatalogSiteName())) {
                    return this._projectManager.getUserProjects(identity).keySet();
                }
                return this._projectManager.getProjectsForSite(site);
            }
            catch (ProjectManager.UnknownCatalogSiteException unknownCatalogSiteException) {
                // empty catch block
            }
        }
        return List.of();
    }

    protected Collection<String> getHandledRights(UserIdentity identity, Set<GroupIdentity> groups, Object object) {
        HashSet<String> rights = new HashSet<String>(this._managerRights);
        rights.addAll(this._memberRights);
        return rights;
    }
}

