/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

try
{
    let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
    let workspaceModuleExtensionPoint = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint.ROLE);
    
    let countProjects = 0;
    let error = "";
    projectManager.getProjects().forEach(function (project) 
    {
        let module = workspaceModuleExtensionPoint.getModule('org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule');
        let pages = projectManager.getModulePages(project, module);
        for (let page of pages)
        {
            if (page.getNode().hasNode("ametys-internal:zones/default/ametys-internal:zoneItems/ametys:zoneItem/ametys:service_parameters"))
            {
                let serviceNode = page.getNode().getNode("ametys-internal:zones/default/ametys-internal:zoneItems/ametys:zoneItem/ametys:service_parameters");   
                if (serviceNode.getProperty("ametys:xslt").getString() == "pages/services/modules/taskslist/task-default.xsl")
                {
                    logger.info(`Migrate tasks for project '${project.getTitle()}'`);
          
                    let projectRootNode = project.getExplorerRootNode();
                    let taskNode = projectRootNode.getChild("tasks");
                    if (!taskNode.hasChild("default"))
                    {
                        logger.info(`Migrate service page '${page.getId()}'`);
                        serviceNode.setProperty("ametys:xslt", "pages/services/modules/tasks/tasks-default.xsl");
                        serviceNode.save();
                        
                        try 
                        {
                            let livePage = Repository.resolver.resolveById(page.getId(), Repository.liveSession);
                            let liveServiceNode = livePage.getNode().getNode("ametys-internal:zones/default/ametys-internal:zoneItems/ametys:zoneItem/ametys:service_parameters");   
                            if (liveServiceNode.getProperty("ametys:xslt").getString() == "pages/services/modules/taskslist/task-default.xsl")
                            {
                                logger.info(`Migrate service live page '${livePage.getId()}'`);
                                liveServiceNode.setProperty("ametys:xslt", "pages/services/modules/tasks/tasks-default.xsl");
                            }
                            liveServiceNode.save();
                        }
                        catch (e) {/* No page live */}
                    }
                    else
                    {
                        let taskNode = projectRootNode.getChild("tasks");
                        let tasksList = taskNode.getChild("default");
                        if (countProjects != 0)
                        {
                            error += ", "
                        }
                        error +=  `[${project.getTitle()}] ${tasksList.getChildren().getSize()} task(s) to delete`;
                        countProjects++;
                    }
                }
            }
        }
    });
    
    if (countProjects > 0)
    {
        throw new Error(`${countProjects} project(s) has old tasks : ${error}. Remove old tasks manually with the migration guide https://docs.ametys.org/fr/search.html?textfield=%22plugin.workspaces.jcr.v20210702T0000-WORKSPACES-858%22&submit-form=mainSearch and restart Ametys to process the migration.`);
    }
}
catch (generalException)
{
    if (!Ametys.serviceManager.lookup("org.ametys.plugins.repository.migration.jcr.data.VersionsRootHelper").hasKnownPlugins())
    {
        const DateUtils = Java.type("org.ametys.core.util.DateUtils");
        const DATE_FORMATTER = java.time.format.DateTimeFormatter.ofPattern("dd/MM/yyyy");
        let deliverDate = '2020-08-01';
        
        let oldMigrationsToCheck = Repository.query(`//element(*, ametys:version)[not(fn:name() = 'v-0') and jcr:like(@ametys:comment, 'Automatic Initialization%') and @ametys:executionDate > xs:dateTime('${deliverDate}T00:00:00.000+01:00')]`);
        if (oldMigrationsToCheck.getSize() > 0)
        {
            logger.warn("Old migrations to check:");
            oldMigrationsToCheck.forEach(
                version =>
                {
                    logger.warn(` + ${DATE_FORMATTER.format(DateUtils.asZonedDateTime(version.getExecutionDate()))} ${version.getVersionNumber()} ${version.getComponentId()} ${version.getComment()}`);
                }
            );
            
            throw new Error(`There is at most ${oldMigrationsToCheck.getSize()} migrations that have previously failed silently, you have to verify it manually. Please compare the execution date (first display field) of the migrations showed above with your first installation date, if the date is later than the first installation date, you have to check each migration manually. You can find some help to solve it in the following issue: https://issues.ametys.org/browse/REPOSITORY-493`, e);
        }
    }
    
    throw generalException;
}