/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
 Project = {
    
    /**
     * Join a public project
     * @param {String} projectId the id of project to join
     */
    join: function(projectId)
    {
        var me = this;
        
        $j('[data-join-project="' + projectId + '"]').dialog({
            resizable: false,
            height: 'auto',
            width: 500,
            modal: true,
            title: "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT}}".replace('<br/>', ' '),
            buttons: {
                "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ACTION}}": function () {
                    
                    var dialog = $j(this).closest("[data-join-project]");
                    
                    AmetysFront.ServerComm.callMethod({
                        role: 'org.ametys.plugins.workspaces.project.ProjectsCatalogueManager',
                        methodName: 'joinProject',
                        parameters: [projectId],
                        callback: {
                            handler: me._joinCb,
                            scope: me,
                            arguments: [dialog]
                        }
                    });
                }
            }
        });
    },
    
    _joinCb: function(result, args)
    {
        if (result && result.success)
        {
            // close dialog
            args[0].dialog("close");
            
            AmetysFront.Utils.info("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ACTION}}", "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_JOINED}}");
            window.location.href = result.url;
        }
        else
        {
            AmetysFront.Utils.error("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_JOIN_FAIL_TEXT}}", "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_JOIN_FAIL}}");
        }
    },
    
    /**
     * Ask to join a moderated project
     * @param {String} projectId the id of project to join
     */
    askToJoin: function(projectId)
    {
        var me = this;
        
        $j('[data-join-project="' + projectId + '"]').dialog({
            resizable: false,
            height: 'auto',
            width: 500,
            modal: true,
            title: "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT}}".replace('<br/>', ' '),
            buttons: {
                "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_ACTION}}": function () {
                    
                    var dialog = $j(this).closest("[data-join-project]");
                    var message = $j(this).find("textarea").val();
                    
                    AmetysFront.ServerComm.callMethod({
                        role: 'org.ametys.plugins.workspaces.project.ProjectsCatalogueManager',
                        methodName: 'askToJoinProject',
                        parameters: [projectId, message],
                        callback: {
                            handler: me._askToJoinCb,
                            scope: me,
                            arguments: [dialog]
                        }
                    });
                }
            }
        });
    },
    
    _askToJoinCb: function(result, args)
    {
        if (result && result.success)
        {
            // close dialog
            args[0].dialog("close");
            
            var text = result['added-notification'] ? "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_SUCCESS}}" : "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_SUCCESS_NO_NOTIF}}"
            AmetysFront.Utils.info("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ACTION}}", text);
        }
        else
        {
            AmetysFront.Utils.error("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_FAIL_TEXT}}", "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_CATALOGUE_JOINPROJECT_ASK_FAIL}}");
        }
    },
    
    /**
     * Make the current user leave project
     * @param {String} project the project
     * @param {Function} [callback] the callback function to invoked after reacting to content
     */
    leaveProject: function(project, callback)
    {
        var me = this;
        AmetysFront.Utils.confirm("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_LEAVE_PROJECT_TITLE}}", "{{i18n plugin.workspaces:PLUGINS_WORKSPACES_LEAVE_PROJECT_CONFIRM}}", function () {
           me._leaveProjectConfirm(project, callback);
        });
        
        return false;
    },

    _leaveProjectConfirm: function(project, callback)
    {
        AmetysFront.ServerComm.callMethod({
            role: 'org.ametys.plugins.workspaces.members.ProjectMemberManager',
            methodName: 'leaveProject',
            parameters: [project],
            callback: {
                handler: this._leaveProjectCb,
                scope: this,
                arguments: [callback]
            }
        });
    },
    
    
    _leaveProjectCb: function (result, args)
     {
        if (result)
        {
            if (result.success)
            {
                var callback = args[0];
                if (typeof (callback) == 'function')
                {
                    callback();
                }
            }
            else
            {
                if (result["message"] == "unknown-project")
                {
                    AmetysFront.Utils.error("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_MEMBERS_UNKNOWN_PROJECT_ERROR_TEXT}}");
                }
                if (result["message"] == "only-manager")
                {
                    AmetysFront.Utils.error("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_LEAVE_PROJECT_ONLY_MANAGER_ERROR}}");
                }
                if (result["message"] == "unknown-member")
                {
                    AmetysFront.Utils.error("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_LEAVE_PROJECT_UNKNOWN_MEMBER_ERROR}}");
                }
            }
        }
        else
        {
            AmetysFront.Utils.error("{{i18n plugin.workspaces:PLUGINS_WORKSPACES_MEMBERS_GENERAL_ERROR_TEXT}}");
        }
     },
    
 }