/* eslint-disable */

/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';

Vue.config.productionTip = false;

import * as EventsStore from '../../_components/store/calendar/EventsStore';
import * as CalendarsStore from '../../_components/store/calendar/CalendarsStore';
import * as EventFiltersStore from '../../_components/store/calendar/EventFiltersStore';
import * as ResourcesStore from '../../_components/store/calendar/ResourcesStore';
import * as UserRightsStore from '../../_components/store/calendar/UserRightsStore';
import * as ColorsStore from '../../_components/store/project-tags/ColorsStore';
import * as TagsStore from '../../_components/store/project-tags/TagsStore';

import axios from 'axios';
axios.defaults.baseURL = 'http://localhost:3000';
window.axios = axios;

// Plugins
import './plugins/tippy';

// eslint-disable-next-line

import App from './vueserve/CalendarModule';

window['vue-calendar-run'] = function (selector, config) {
    
    var colorsMap = config.colorsMap();
    const store = new Vuex.Store({
        state: {
            restrictedColorsMap: colorsMap.colors,
            colorsMap: {...colorsMap.resourceColor, ...colorsMap.colors},
            resourceCalendar: config.resourceCalendar(),
            recurrenceTypes: config.recurrenceTypes(),
            glyphs: config.glyphs()
        },
    modules: {
      events: EventsStore,
      calendars: CalendarsStore,
      filters: EventFiltersStore,
      resources: ResourcesStore,
      userRights: UserRightsStore,
      colors: ColorsStore,
      tags: TagsStore
    },
  });

    
  return new Vue({
    store,
    render: (h) => h(App, {props: config}),
    vuetify: new Vuetify({
      theme: {
        options: {
          customProperties: true,
        },
        themes: {
          light: {
            primary: '#9575CD',
            background: '#f7f8fa',
          },
          dark: {
            primary: '#9575CD',
          },
          baseFontSize: '16px',
        },
      },
    }),
  }).$mount(selector);
};
