/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';

import VueSanitize from "vue-sanitize";
Vue.use(VueSanitize);

import VueSmoothScroll from 'vue2-smooth-scroll'
Vue.use(VueSmoothScroll);

Vue.config.productionTip = false;

import * as FoldersStore from '../../_components/store/file-manager/FoldersStore';
import * as MoveFoldersAndFilesStore from "../../_components/store/file-manager/MoveFoldersAndFilesStore";
import * as FilesStore from '../../_components/store/file-manager/FilesStore';
import * as CommentsStore from '../../_components/store/file-manager/CommentsStore';
import * as ActivityStore from '../../_components/store/file-manager/FileActivityStore';
import * as FiltersStore from '../../_components/store/file-manager/FiltersStore';
import * as SelectedItemsStore from '../../_components/store/file-manager/SelectedItemsStore';
import * as PreviewItemStore from '../../_components/store/file-manager/PreviewItemStore';
import * as TagsStore from '../../_components/store/project-tags/TagsStore';
import * as ColorsStore from '../../_components/store/project-tags/ColorsStore';
import * as ProjectMembersStore from '../../_components/store/project-members/ProjectMembersStore';

// eslint-disable-next-line
const store = new Vuex.Store({
  modules: {
    folders: FoldersStore,
    moveFoldersAndFiles: MoveFoldersAndFilesStore,
    files: FilesStore,
    comments: CommentsStore,
    activity: ActivityStore,
    filters: FiltersStore,
    selectedItems: SelectedItemsStore,
    info: PreviewItemStore,
    tags: TagsStore,
    colors: ColorsStore,
    members: ProjectMembersStore
  }
});

// Vue base component
import App from './vueserve/FileManagerModule.vue';

// Init App
window['vue-file-manager-run'] = function (selector, config) {
  return new Vue({
    store,
    render: h => h(App, {props: config}),
    /* global Vuetify */
    vuetify: new Vuetify({
      theme: {
        themes: {
          light: {
            primary: '#9575CD'
          },
          dark: {
            primary: '#9575CD'
          }
        }
      }
    })
  }).$mount(selector);
};