/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { mapState, mapGetters, mapMutations} from 'vuex';
import _ from 'lodash/lodash'
export default {
  data() {
    return {
      editorApiKey: '1u4vs4thoz07t3cap2uny11mwwqwpduioeemv31pltkarmrx',
      tagColors: ['red', 'pink', 'purple', 'blue', 'teal', 'green', 'orange'],
    };
  },
  computed: {
    ...mapGetters({
      filters: 'thread/FILTERS',
    }),
    ...mapState({
        threadCategories: state => state.threadCategories,
      }),
    lessMd(){
      return this.$vuetify.breakpoint.width <= 992;
    }
  },
  methods: {
    ...mapMutations({
      updateFilters: 'thread/SET_FILTERS',
    }),
    get(obj, slug, falsyValue = '', prefix = '', suffix = '', func = '') {
      if ((!obj && typeof obj != 'object') || obj === null) return falsyValue;
      let result = _.cloneDeep(obj);
      const nests = slug.split('.');

      for (const nest of nests) {
        if (result[nest] === null || typeof result[nest] === 'undefined') {
          result = falsyValue;
          break;
        } else {
          result = result[nest];
        }
      }

      if (result !== falsyValue) {
        if (prefix) result = prefix + result;

        if (suffix) result = result + suffix;

        if (func) result = func(result);
      }

      return result;
    },
    toQueryStr(obj) {
      if (obj) {
        let str = '';
        for (const key in obj) {
          if (!key) continue;
          if (str == '') str += `${key}=${obj[key]}`;
          else str += `&${key}=${obj[key]}`;
        }
        return str;
      }
    },
    getQuery(key = null) {
      const filters = _.cloneDeep(this.filters);
      return key ? this.get(filters, key) : filters;
    },
    async setRouteQuery(query) {
      this.updateFilters(query);
    },
    isEmptyObj(obj) {
      for (const prop in obj) {
        if (obj[prop]) return false;
      }
      return true;
    },
    cloneDeep(obj) {
      return _.cloneDeep(obj);
    },
  },
};
