/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';
Vue.config.productionTip = false;

import Vuex from 'vuex';

Vue.use(Vuex);
import * as MembersStore from '../../_components/store/members/MembersStore';
import * as SearchUsersStore from '../../_components/store/members/SearchUsersStore';

const store = new Vuex.Store({
  modules: {
    members: MembersStore,
    searchUsers: SearchUsersStore
  }
});

import Vuetify from 'vuetify';

// Import Directives
import './directives';

import App from './vueserve/MembersModule.vue';

window['vue-members-run'] = function (selector) {
  return new Vue({
    store,
    render: h => h(App),
    vuetify: new Vuetify({
      theme: {
        themes: {
          light: {
            primary: '#9575CD'
          },
          dark: {
            primary: '#9575CD'
          }
        }
      }
    })
  }).$mount(selector);
};

