/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.calendars;

import java.util.List;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityNotifier;

/**
 * Class representing a activity notifier for calendar event workspaces
 */
public class CalendarEventActivityNotifier extends AbstractWorkspacesActivityNotifier
{
    public boolean support(ActivityType activityType)
    {
        return activityType instanceof CalendarEventActivityType;

    }
    
    @Override
    public List<String> getSubjectI18nParams(Activity activity)
    {
        List<String> i18nParams = super.getSubjectI18nParams(activity);                                     // {0} project title
        
        i18nParams.add(activity.getValue(AbstractCalendarEventActivityType.CALENDAR_EVENT_TITLE));  // {1} event title
        i18nParams.add(activity.getValue(AbstractCalendarEventActivityType.CALENDAR_TITLE));        // {2} calendar title
        return i18nParams;
    }

    @Override
    public String getMailBodyURI(Activity activity)
    {
        return "cocoon://_plugins/workspaces/notification-mail-calendar-event";
    }
    
    @Override
    public AmetysObject getTargetAmetysObject(Activity activity)
    {
        String calendarEventId = activity.getValue(AbstractCalendarEventActivityType.CALENDAR_EVENT_ID);
        return _resolver.resolveById(calendarEventId);
    }
}
