/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.List;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.WorkspacesConstants;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityNotifier;

/**
 * Class representing a activity notifier for web content in workspaces
 */
public class WebContentActivityNotifier extends AbstractWorkspacesActivityNotifier
{
    public boolean support(ActivityType activityType)
    {
        return activityType instanceof WebContentActivityType;
    }
    
    @Override
    public String getMailBodyURI(Activity activity)
    {
        ActivityType activityType = activity.getActivityType();
        if (activityType instanceof ContentCommentedActivityType)
        {
            switch (activity.<String>getValue(WebContentActivityType.CONTENT_TYPE))
            {
                case WorkspacesConstants.PROJECT_NEWS_CONTENT_TYPE_ID:
                    return "cocoon://_plugins/workspaces/notification-mail-news-comment";
                case WorkspacesConstants.WALL_CONTENT_CONTENT_TYPE_ID:
                    return "cocoon://_plugins/workspaces/notification-mail-wallcontent-comment";
                default:
                    // This case should not happened has it would have been filtered by the support method
                    return "cocoon://_plugins/workspaces/notification-mail-comment";
            }
        }
        else if (activityType instanceof NewsPublishedActivityType)
        {
            return "cocoon://_plugins/workspaces/notification-mail-news-publication";
        }
        
        return "cocoon://_plugins/workspaces/notification-mail-wallcontent";
    }
    
    @Override
    public List<String> getSubjectI18nParams(Activity activity)
    {
        List<String> params = super.getSubjectI18nParams(activity);         // {0} project title
        params.add(activity.getValue(WebContentActivityType.CONTENT_TITLE));   // {1} content title
        return params;
    }
    
    @Override
    public AmetysObject getTargetAmetysObject(Activity activity)
    {
        return _resolver.resolveById(activity.getValue(WebContentActivityType.CONTENT_ID));
    }
}
