/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.tasks;

import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;

/**
 * Class representing a activity notifier for tasks closed in workspaces
 */
public class TasksClosedActivityNotifier extends TasksActivityNotifier
{
    @Override
    public boolean support(ActivityType activityType)
    {
        return activityType instanceof TaskClosedStatusChangedActivityType;
    }
    
    @Override
    protected String _getSubjectI18nKey(Activity activity)
    {
        String isClose = activity.getValue(TaskClosedStatusChangedActivityType.IS_CLOSED);
        String key = "PROJECT_MAIL_NOTIFICATION_SUBJECT_";
        key += isClose.equals("true") ? "CLOSE_" : "OPEN_";
        return key + StringUtils.replaceChars(activity.getEventType().toUpperCase(), '.', '_');
    }
}
