/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars;

import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;

/**
 * Modifiable Calendar Interface
 */
public interface ModifiableCalendar extends Calendar, ModifiableTraversableAmetysObject, ModifiableModelAwareDataAwareAmetysObject, RemovableAmetysObject, ModifiableExplorerNode
{
    /**
     * set the description of the calendar
     * @param desc The description
     */
    public void setDescription(String desc);
    
    /**
     * set the color of the calendar
     * @param color The color to set
     */
    public void setColor(String color);
    
    /**
     * Set the visibility of the calendar
     * @param visibility The visibility
     */
    public void setVisibility(CalendarVisibility visibility);
    
    /**
     * set the name of the workflow of the calendar
     * @param workflowName The workflow name
     */
    public void setWorkflowName(String workflowName);
    

    /**
     * set the template description of the calendar
     * @param templateDesc The template description
     */
    public void setTemplateDescription(String templateDesc);
    
    /**
     * Set the token used by the ICS public URL
     * @param token The token, or null to delete the existing token
     */
    public void setIcsUrlToken(String token);
}
