/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars.jcr;

import javax.jcr.Node;

import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link AmetysObjectFactory} for handling {@link JCRCalendarEvent}s.
 */
public class JCRCalendarEventFactory extends DefaultTraversableAmetysObjectFactory
{
    /** JCR nodetype for resources collection */
    public static final String CALENDAR_EVENT_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":calendar-event";

    /** The calendar event model */
    private Model _calendarEvent;
    
    @Override
    public JCRCalendarEvent getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new JCRCalendarEvent(node, parentPath, this);
    }
    
    /**
     * Get the calendar event model
     * @return the calendar event model
     */
    public Model getCalendarEventModel()
    {
        if (_calendarEvent == null)
        {
            try
            {
                String role = ModelItemTypeExtensionPoint.ROLE_MODEL_AWARE_BASIC;
                _calendarEvent = Model.of(
                        "calendar.event.model.id", 
                        "calendar.event.model.family.id",
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_CREATOR, false, org.ametys.cms.data.type.ModelItemTypeConstants.USER_ELEMENT_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_CREATION, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_CONTRIBUTOR, false, org.ametys.cms.data.type.ModelItemTypeConstants.USER_ELEMENT_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_MODIFIED, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_TITLE, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_DESC, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_KEYWORDS, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_LOCATION, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_START_DATE, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_END_DATE, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_DATE_ZONE, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_FULL_DAY, false, ModelItemTypeConstants.BOOLEAN_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_RECURRENCE_TYPE, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_UNTIL_DATE, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_EXCLUDED_DATE, true, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_RESOURCES, true, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(JCRCalendarEvent.ATTRIBUTE_ORGANISER, false, org.ametys.cms.data.type.ModelItemTypeConstants.USER_ELEMENT_TYPE_ID, role)   
                        );
            }
            catch (Exception e) 
            {
                getLogger().error("An error occurred getting the calendar resource model", e);
                throw new RuntimeException("An error occurred getting the calendar resource model", e);
            }
        }
        return _calendarEvent;
    }
}
