/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.forum.filters;

import java.io.IOException;

import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Filter to check if a thread has a text in the title or content
 */
public class TextSearchFilter extends AbstractLogEnabled implements ThreadFilter
{
    private String _search;
    private ThreadJSONHelper _threadJSONHelper;
    
    /**
     * Filter to check if a thread has a text in the title or content
     * @param search the search text
     * @param threadJSONHelper the Thread JSON Helper
     */
    public TextSearchFilter(String search, ThreadJSONHelper threadJSONHelper) 
    {
        _search = search;

        _threadJSONHelper = threadJSONHelper;
    }
    
    public boolean passFilter(Thread thread)
    {
        if (_search == null)
        {
            return true;
        }
        String simpleText = _threadJSONHelper.richTextToSimpleText(thread.getContent(), 0);
        return _contains(thread.getTitle(), _search) || _contains(simpleText, _search);
    }

    private boolean _contains(String sequence, String searchSequence)
    {
        return org.ametys.core.util.StringUtils.normalizeStringValue(sequence).contains(searchSequence);
    }
}
