/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.initialization;

import java.util.Optional;

import org.ametys.runtime.plugin.component.Prioritizable;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.Page;

/**
 * Interface for the creation of a new page with predefined content and configuration
 * This can for example be use to generate some default pages during site initialization
 */
public interface PageInitializer extends Prioritizable
{
    /**
     * Create a new page in the parent
     * @param parent the parent where the new page should be created
     * @return the new page or empty if no page was created
     */
    public Optional< ? extends Page> createPage(ModifiableSitemapElement parent);
}
