/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightManager.RightResult;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workspaces.project.ProjectConstants;

/**
 * DAO for manipulating project's tags
 */
public class KeywordsDAO extends AbstractTagsDAO
{
    /** The avalon role */
    public static final String ROLE = KeywordsDAO.class.getName();

    private RightManager _rightManager;
    private KeywordJCRDAO _keywordJCRDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _rightManager = (RightManager) manager.lookup(RightManager.ROLE);
        _keywordJCRDAO = (KeywordJCRDAO) manager.lookup(KeywordJCRDAO.ROLE);
    }
    
    @Override
    public String getTagProviderEPRole()
    {
        return KeywordProviderExtensionPoint.ROLE;
    }

    @Override
    protected List<TagProvider< ? extends Tag>> getCustomTagProvider()
    {
        List<TagProvider<? extends Tag>> providers = new ArrayList<>();
        providers.add(_tagProviderExtPt.getExtension(KeywordJCRProvider.class.getName()));
        
        return providers;
    }

    /**
     * Get existing tags
     * @return the tags (id and label)
     */
    @Callable
    public Map<String, Object> getKeywords()
    {
        List<Map<String, Object>> tags = new ArrayList<>();
        
        for (String id : _tagProviderExtPt.getExtensionsIds())
        {
            TagProvider<? extends Tag> tagProvider = _tagProviderExtPt.getExtension(id);
            Map<String, ? extends Tag> someTags = tagProvider.getTags(Collections.emptyMap());

            tags.addAll(_tagsToJSON(someTags.values()));
        }
        
        Map<String, Object> result = new HashMap<>();
        result.put("keywords", tags);
        result.put("canCreate", _rightManager.currentUserHasRight(ProjectConstants.RIGHT_PROJECT_HANDLE_PROJECTKEYWORDS, "/cms") == RightResult.RIGHT_ALLOW);
        return result;
    }

    @Override
    protected AbstractJCRTagsDAO _getTagJCRDAO()
    {
        return _keywordJCRDAO;
    }
}
