/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.preferences;

import java.util.Map;
import java.util.Map.Entry;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.SAXException;

import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.workspaces.members.JCRProjectMember.MemberType;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.userpref.FOUserPreferencesGenerator;

/**
 * Generator for the workspace preference service
 * 
 * This generator retrieve the service parameters in the userPref and sax them
 */
public class PreferenceServiceGenerator extends FOUserPreferencesGenerator
{
    private ProjectManager _projectManager;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _projectManager = (ProjectManager) smanager.lookup(ProjectManager.ROLE);
    }
    
    @Override
    protected void _saxPreferences(String storageContext, Map<String, String> contextVars, UserIdentity user, boolean excludePrivate)
            throws ProcessingException, SAXException, UserPreferencesException
    {
        super._saxPreferences(storageContext, contextVars, user, excludePrivate);
        _saxProjects(user);
    }
    
    private void _saxProjects(UserIdentity user) throws SAXException
    {
        Map<Project, MemberType> userProjects = _projectManager.getUserProjects(user);
        XMLUtils.startElement(contentHandler, "userProjects");
        for (Entry<Project, MemberType> entry : userProjects.entrySet())
        {
            Project project = entry.getKey();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", project.getId());
            attrs.addCDATAAttribute("name", project.getName());
            
            XMLUtils.startElement(contentHandler, "project", attrs);
            
            XMLUtils.createElement(contentHandler, "title", project.getTitle());
            
            String description = project.getDescription();
            if (description != null)
            {
                XMLUtils.createElement(contentHandler, "description", description);
            }
            XMLUtils.endElement(contentHandler, "project");
        }
        XMLUtils.endElement(contentHandler, "userProjects");
    }

}
