/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.workspaces.tasks;

import org.ametys.web.color.AbstractSkinColorsComponent;

/**
 * Component listing the available colors for a tasks list
 * First getting colors in skin://conf/tasks-list-colors.xml
 * If not, getting colors in /WEB-INF/param/tasks-list-colors.xml
 * If not, getting default colors in plugin.xml
 */
public class TasksListColorsComponent extends AbstractSkinColorsComponent
{
    /** The component role */
    public static final String ROLE = TasksListColorsComponent.class.getName();
    
    /** The path to the project tag colors file */
    private static final String __CONF_PROJECT_TASKS_LIST_COLORS_FILE_PATH = "conf/tasks-list-colors.xml";
    
    @Override
    protected String _getColorSkinFilePath()
    {
        return __CONF_PROJECT_TASKS_LIST_COLORS_FILE_PATH;
    }
}
