/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.repository.ModifiableWorkflowAwareContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.transformation.Configuration2XMLValuesTransformer;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.extractor.xml.ModelAwareXMLValuesExtractor;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.workflow.component.CheckRightsCondition;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.service.Service;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinTemplate;
import org.ametys.web.skin.SkinTemplateZone;
import org.ametys.web.skin.SkinsManager;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PagePopulator
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = PagePopulator.class.getName();
    protected SourceResolver _sourceResolver;
    protected I18nUtils _i18nUtils;
    protected ServiceExtensionPoint _serviceEP;
    protected ObservationManager _observationManager;
    protected ContentWorkflowHelper _workflowHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected PageDAO _pageDAO;
    protected ProfileAssignmentStorageExtensionPoint _profileAssignementStorageEP;
    protected SkinsManager _skinsManager;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected SAXParser _saxParser;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._profileAssignementStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._serviceEP = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
        this._skinsManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._workflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._saxParser = (SAXParser)manager.lookup(SAXParser.ROLE);
    }

    public Optional<ModifiablePage> initPage(ModifiableSitemapElement parent, String path) throws IOException, SAXException, ConfigurationException {
        Source cfgFile = null;
        try {
            Optional<ModifiablePage> optional;
            block12: {
                cfgFile = this._sourceResolver.resolveURI(path);
                if (!cfgFile.exists()) {
                    throw new SourceNotFoundException(cfgFile.getURI() + " does not exist");
                }
                InputStream is = cfgFile.getInputStream();
                try {
                    Configuration configuration = new DefaultConfigurationBuilder().build(is);
                    optional = this.initPage(parent, configuration);
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConfigurationException e) {
                        throw new ConfigurationException("There is an issue with configuration file '" + cfgFile.getURI() + "'. This prevented the initialization of the page.", (Throwable)e);
                    }
                }
                is.close();
            }
            return optional;
        }
        finally {
            this._sourceResolver.release(cfgFile);
        }
    }

    public Optional<ModifiablePage> initPage(ModifiableSitemapElement parent, Configuration configuration) throws ConfigurationException {
        Optional<ModifiablePage> page = this.createPage(parent, configuration);
        if (page.isPresent()) {
            ModifiablePage newPage = page.get();
            this.configurePage(newPage, configuration);
            this.setReaderAccess(newPage, configuration);
            newPage.saveChanges();
        }
        return page;
    }

    protected Optional<ModifiablePage> createPage(ModifiableSitemapElement parent, Configuration configuration) throws ConfigurationException {
        String lang = parent.getSitemapName();
        I18nizableText i18nTitle = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("title"), (String)"application");
        String title = this._i18nUtils.translate((I18nizable)i18nTitle, lang);
        String name = configuration.getAttribute("name", NameHelper.filterName((String)(title = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)"Missing title"))));
        if (!parent.hasChild(name)) {
            return Optional.of(this._pageDAO.createPage(parent, name, title, null));
        }
        return Optional.empty();
    }

    protected void configurePage(ModifiablePage newPage, Configuration configuration) throws ConfigurationException {
        String templateName;
        Configuration tagsCfg = configuration.getChild("tags", true);
        List<String> tags = Arrays.stream(tagsCfg.getChildren("tag")).map(cfg -> cfg.getValue("")).filter(StringUtils::isNotEmpty).toList();
        if (!tags.isEmpty()) {
            this._pageDAO.tag(newPage, tags, ContentDAO.TagMode.INSERT);
        }
        if ((templateName = configuration.getAttribute("template", null)) != null) {
            Skin skin = this._skinsManager.getSkin(newPage.getSite().getSkinId());
            if (skin == null) {
                this.getLogger().warn("The site is configured with an unexisting skin. Impossible to configure the page.");
                return;
            }
            SkinTemplate template = skin.getTemplate(templateName);
            if (template == null) {
                throw new ConfigurationException("Trying to configure page with an unexisting template named '" + templateName + "' for skin '" + skin.getId() + "'.");
            }
            newPage.setType(Page.PageType.CONTAINER);
            newPage.setTemplate(templateName);
            Configuration templateParams = configuration.getChild("parameters", false);
            if (templateParams != null) {
                DataContext context = DataContext.newInstance();
                context.withLocale(LocaleUtils.toLocale((String)newPage.getSitemapName()));
                try {
                    Element paramsElement = this._interpretConfiguration(templateParams, context);
                    ModifiableModelAwareDataHolder templateParametersHolder = newPage.getTemplateParametersHolder();
                    ModelAwareXMLValuesExtractor extractor = new ModelAwareXMLValuesExtractor(paramsElement, templateParametersHolder.getModel());
                    templateParametersHolder.synchronizeValues(extractor.extractValues());
                    HashMap<String, ModifiablePage> eventParams = new HashMap<String, ModifiablePage>();
                    eventParams.put("sitemapelement", newPage);
                    this._observationManager.notify(new Event("view.parameters.modified", this._currentUserProvider.getUser(), eventParams));
                }
                catch (Exception e) {
                    this.getLogger().warn("Failed to set template parameters for page '" + newPage.getName() + "'.", (Throwable)e);
                }
            }
            Map templateZones = template.getZones();
            for (Configuration zoneCfg : configuration.getChildren("zone")) {
                SkinTemplateZone templateZone = (SkinTemplateZone)templateZones.get(zoneCfg.getAttribute("id"));
                if (templateZone == null) {
                    throw new ConfigurationException("Trying to configure unexisting page zone '" + zoneCfg.getAttribute("id") + "' for template '" + templateName + "' in skin '" + skin.getId() + "'.");
                }
                this.createAndConfigureZone(newPage, zoneCfg);
            }
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("page", newPage);
            eventParams.put("page.id", newPage.getId());
            this._observationManager.notify(new Event("page.changed", this._currentUserProvider.getUser(), eventParams));
        }
    }

    protected void createAndConfigureZone(ModifiablePage newPage, Configuration zoneCfg) throws ConfigurationException {
        String zoneId = zoneCfg.getAttribute("id");
        ModifiableZone zone = newPage.createZone(zoneId);
        for (Configuration itemCfg : zoneCfg.getChildren()) {
            if (StringUtils.equals((CharSequence)itemCfg.getName(), (CharSequence)"service")) {
                this.createAndConfigureServiceItem(zone, itemCfg);
                continue;
            }
            if (!StringUtils.equals((CharSequence)itemCfg.getName(), (CharSequence)"content")) continue;
            this.createAndConfigureContentItem(zone, itemCfg);
        }
    }

    protected void createAndConfigureServiceItem(ModifiableZone zone, Configuration serviceCfg) throws ConfigurationException {
        String serviceId = serviceCfg.getAttribute("id");
        Service service = (Service)this._serviceEP.getExtension(serviceId);
        if (service != null) {
            ModifiableZoneItem item = zone.addZoneItem();
            item.setType(ZoneItem.ZoneType.SERVICE);
            item.setServiceId(serviceId);
            DataContext dataContext = DataContext.newInstance();
            dataContext.withLocale(LocaleUtils.toLocale((String)zone.getSitemapElement().getSitemapName()));
            try {
                Element xmlValues = this._interpretConfiguration(serviceCfg, dataContext);
                ModelAwareXMLValuesExtractor extractor = new ModelAwareXMLValuesExtractor(xmlValues, new Model[]{service});
                item.getServiceParameters().synchronizeValues(extractor.extractValues());
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to extract the value from configuration for item with service id '" + serviceId + "'.", (Throwable)e);
            }
        } else {
            throw new ConfigurationException("Trying to create unexisting service '" + serviceId + "' for page '" + zone.getSitemapElement().getName() + "'.");
        }
    }

    protected void createAndConfigureContentItem(ModifiableZone zone, Configuration contentCfg) throws ConfigurationException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(CreateContentFunction.SITE_KEY, zone.getSitemapElement().getSiteName());
        try {
            Configuration cTypesCfg = contentCfg.getChild("contentTypes");
            Configuration[] cTypeCfgs = cTypesCfg.getChildren("contentType");
            String[] cTypeIds = new String[cTypeCfgs.length];
            Model[] cTypes = new Model[cTypeCfgs.length];
            String workflowName = "content";
            int i = 0;
            for (Configuration cfg : cTypeCfgs) {
                String cTypeId = cfg.getAttribute("id");
                ContentType contentType = (ContentType)this._contentTypeEP.getExtension(cTypeId);
                if (contentType == null) {
                    throw new ConfigurationException("Could not create new content for page '" + zone.getSitemapElement().getName() + "'. The configuration file references an unexisting content type '" + cTypeId + "'.");
                }
                cTypes[i] = contentType;
                cTypeIds[i++] = cTypeId;
                Optional defaultWorkflow = contentType.getDefaultWorkflowName();
                if (!defaultWorkflow.isPresent()) continue;
                workflowName = (String)defaultWorkflow.get();
            }
            Configuration workflow = contentCfg.getChild("workflow");
            workflowName = workflow.getAttribute("name", "content");
            DataContext dataContext = DataContext.newInstance();
            dataContext.withLocale(LocaleUtils.toLocale((String)zone.getSitemapElement().getSitemapName()));
            Element xmlValues = this._interpretConfiguration(contentCfg, dataContext);
            ModelAwareXMLValuesExtractor extractor = new ModelAwareXMLValuesExtractor(xmlValues, Arrays.asList(cTypes));
            Map contentValues = extractor.extractValues();
            String title = (String)contentValues.get("title");
            if (title == null) {
                throw new ConfigurationException("Failed to retrieve a translation for the provided configuration.", contentCfg.getChild("title"));
            }
            String name = NameHelper.filterName((String)contentCfg.getAttribute("name", title));
            int createAction = workflow.getAttributeAsInteger("init-action-id", 1);
            ModifiableWorkflowAwareContent content = (ModifiableWorkflowAwareContent)this._workflowHelper.createContent(workflowName, createAction, name, title, cTypeIds, null, zone.getSitemapElement().getSitemapName(), params).get(AbstractContentWorkflowComponent.CONTENT_KEY);
            content.synchronizeValues(contentValues);
            Configuration tagsCfg = contentCfg.getChild("tags");
            for (Configuration tag : tagsCfg.getChildren("tag")) {
                content.tag(tag.getValue());
            }
            content.saveChanges();
            int validateAction = workflow.getAttributeAsInteger("validate-action-id", -1);
            if (validateAction > 0) {
                try {
                    HashMap<String, Boolean> inputs = new HashMap<String, Boolean>();
                    inputs.put(CheckRightsCondition.FORCE, true);
                    this._workflowHelper.doAction((WorkflowAwareContent)content, validateAction, inputs);
                }
                catch (InvalidActionException | WorkflowException e) {
                    this.getLogger().warn("Failed to validate new content '" + content.getId() + "'.");
                }
            }
            ModifiableZoneItem item = zone.addZoneItem();
            item.setType(ZoneItem.ZoneType.CONTENT);
            item.setContent((Content)content);
        }
        catch (WorkflowException | AmetysRepositoryException e) {
            this.getLogger().warn("Could not create new content for page '" + zone.getSitemapElement().getName() + "'.");
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to extract content value for page '" + zone.getSitemapElement().getName() + "'.", (Throwable)e);
        }
    }

    private Element _interpretConfiguration(Configuration contentCfg, DataContext dataContext) throws SAXException, ConfigurationException {
        DOMResult domResult = new DOMResult();
        try {
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            th.setResult(domResult);
            Configuration2XMLValuesTransformer handler = new Configuration2XMLValuesTransformer((ContentHandler)th, dataContext, this._i18nUtils);
            new DefaultConfigurationSerializer().serialize((ContentHandler)handler, contentCfg);
            Element values = ((Document)domResult.getNode()).getDocumentElement();
            return values;
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            throw new IllegalStateException("Failed to retrive transformer handler. Impossible to interpret the configuration", e);
        }
    }

    protected void setReaderAccess(ModifiablePage newPage, Configuration configuration) throws ConfigurationException {
        Configuration accessCfg = configuration.getChild("reader-access", true);
        block8: for (Configuration cfg : accessCfg.getChildren()) {
            String name;
            switch (name = cfg.getName()) {
                case "anonymous": {
                    this._setAnonymousPermission((Page)newPage, cfg);
                    continue block8;
                }
                case "any-connected": {
                    this._setAnyConnectedPermission((Page)newPage, cfg);
                    continue block8;
                }
                default: {
                    throw new ConfigurationException("Unknown identity found in configuration. Could not define reader permission", cfg);
                }
            }
        }
    }

    private void _setAnyConnectedPermission(Page page, Configuration cfg) {
        boolean deny = cfg.getAttributeAsBoolean("deny", false);
        if (deny) {
            this._profileAssignementStorageEP.denyProfileToAnyConnectedUser("READER", (Object)page);
            this._notifyACLChange(page, Set.of("READER"));
        } else {
            this._profileAssignementStorageEP.allowProfileToAnyConnectedUser("READER", (Object)page);
            this._notifyACLChange(page, Set.of("READER"));
        }
    }

    private void _setAnonymousPermission(Page page, Configuration cfg) {
        boolean deny = cfg.getAttributeAsBoolean("deny", false);
        if (deny) {
            this._profileAssignementStorageEP.denyProfileToAnonymous("READER", (Object)page);
            this._notifyACLChange(page, Set.of("READER"));
        } else {
            this._profileAssignementStorageEP.allowProfileToAnonymous("READER", (Object)page);
            this._notifyACLChange(page, Set.of("READER"));
        }
    }

    protected void _notifyACLChange(Object context, Set<String> profilesId) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("acl-context", context);
        eventParams.put("acl-profiles", profilesId);
        this._observationManager.notify(new Event("acl.update", this._currentUserProvider.getUser(), eventParams));
    }
}

