/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.AbstractActivityType;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHolder;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractWorkspacesActivityType
extends AbstractActivityType
implements Contextualizable {
    public static final String ACTIVITY_CONTEXT_PARAM = "activity";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_TITLE = "projectTitle";
    public static final String PROJECT_ACCESS = "hasProjectAccess";
    public static final String PROJECT_URL = "projectUrl";
    public static final String PROJECT_CATEGORY = "category";
    protected ProjectManager _projectManager;
    protected ProjectMemberManager _projectMemberManager;
    protected AmetysObjectResolver _resolver;
    protected UserManager _userManager;
    protected I18nUtils _i18nUtils;
    protected Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)serviceManager.lookup(ProjectMemberManager.ROLE));
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    protected void _addValueIfExists(Map<String, Object> json, Activity activity, String dataPath, String key) {
        if (activity.hasValue(dataPath)) {
            json.put(key, activity.getValue(dataPath));
        }
    }

    public void setAdditionalActivityData(Activity activityNode, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activityNode, parameters);
        activityNode.setValue(PROJECT_NAME, parameters.get(PROJECT_NAME));
        activityNode.setValue(PROJECT_TITLE, parameters.get(PROJECT_TITLE));
    }

    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map json = super.additionnalDataToJSONForClient(activity);
        String projectName = (String)activity.getValue(PROJECT_NAME);
        Project project = this._projectManager.getProject(projectName);
        if (project != null) {
            boolean hasAccess = this._projectMemberManager.isProjectMember(project, activity.getAuthor());
            json.put(PROJECT_ACCESS, hasAccess);
            String siteUrl = this._projectManager.getProjectUrl(project, null);
            if (siteUrl != null) {
                json.put(PROJECT_URL, siteUrl);
            }
        }
        return json;
    }

    public boolean isMergeable(Activity activity1, Activity activity2) {
        if (!super.isMergeable(activity1, activity2)) {
            return false;
        }
        String project1 = (String)activity1.getValue(PROJECT_NAME);
        String project2 = (String)activity2.getValue(PROJECT_NAME);
        return project1 != null && project2 != null && project1.equals(project2);
    }

    protected Project getParentProject(AmetysObject ao) {
        AmetysObject parent = ao.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof Project) {
            Project project = (Project)parent;
            return project;
        }
        return this.getParentProject(parent);
    }

    public abstract Expression getFilterPatternExpression(String var1);

    public List<AbstractActivityType.ActivityArguments> getActivitiesArguments(Event event) {
        Project project = this.getProjectFromEvent(event);
        if (project != null) {
            return List.of(new AbstractActivityType.ActivityArguments((ActivityHolder)project, this._getProjectParameters(project)));
        }
        return List.of();
    }

    protected Map<String, Object> _getProjectParameters(Project project) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PROJECT_NAME, project.getName());
        params.put(PROJECT_TITLE, project.getTitle());
        return params;
    }

    public abstract Project getProjectFromEvent(Event var1);
}

