/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.forums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ThreadActivityType
extends AbstractWorkspacesActivityType {
    public static final String THREAD_ID = "threadId";
    public static final String THREAD_TITLE = "threadTitle";
    public static final String THREAD_AUTHOR = "threadAuthor";
    public static final String ACTIVITY_CATEGORY_THREADS = "threads";
    public static final String THREAD_CATEGORY = "threadCategory";
    public static final String THREAD_CREATIONDATE = "threadCreationDate";
    protected ForumWorkspaceModule _forumModule;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._forumModule = (ForumWorkspaceModule)moduleManagerEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        JCRThread thread = (JCRThread)parameters.get("forumthreadthread");
        activity.setValue(THREAD_TITLE, (Object)thread.getTitle());
        activity.setValue(THREAD_AUTHOR, (Object)thread.getAuthor());
        activity.setValue(THREAD_CATEGORY, (Object)thread.getCategory().name());
        activity.setValue(THREAD_ID, (Object)thread.getId());
        activity.setValue("category", (Object)ACTIVITY_CATEGORY_THREADS);
        activity.setValue(THREAD_CREATIONDATE, (Object)thread.getCreationDate());
        activity.setValue(THREAD_CATEGORY, (Object)thread.getCategory().name());
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String threadId = (String)activity.getValue(THREAD_ID);
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        if (!"forumthread.deleted".equals(activity.getEventType())) {
            json.put("threadUrl", this._forumModule.getThreadUri(project, threadId));
        } else {
            json.put("threadUrl", this._forumModule.getModuleUrl(project));
        }
        return json;
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        if (!super.isMergeable(activity1, activity2)) {
            return false;
        }
        String thread1 = (String)activity1.getValue(THREAD_ID);
        String thread2 = (String)activity1.getValue(THREAD_ID);
        return thread1 != null && thread2 != null && thread1.equals(thread2);
    }

    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map mergedActivities = super.mergeActivities(activities);
        ArrayList mergedThreads = new ArrayList();
        for (Activity activity : activities) {
            Map json = activity.toJSONForClient();
            HashMap threadInfo = new HashMap();
            threadInfo.put(THREAD_TITLE, json.get(THREAD_TITLE));
            threadInfo.put(THREAD_ID, json.get(THREAD_ID));
            threadInfo.put("threadUrl", json.get("threadUrl"));
            mergedThreads.add(threadInfo);
        }
        mergedActivities.put(ACTIVITY_CATEGORY_THREADS, mergedThreads);
        return mergedActivities;
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        return new StringExpression(THREAD_TITLE, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        JCRThread thread = (JCRThread)args.get("forumthreadthread");
        return this.getParentProject((AmetysObject)thread);
    }

    public boolean isGenericThreadActivityType() {
        return true;
    }
}

