/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.forums;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.forums.ThreadActivityType;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ThreadCommentActivityType
extends ThreadActivityType {
    public static final String CONTENT = "content";
    public static final String COMMENT_ID = "commentId";
    public static final String COMMENT_AUTHOR = "commentAuthor";
    public static final String COMMENT_AUTHOR_NAME = "commentAuthorName";
    public static final String COMMENT_CREATIONDATE = "commentCreationDate";
    protected ThreadJSONHelper _threadJSONHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._threadJSONHelper = (ThreadJSONHelper)((Object)serviceManager.lookup(ThreadJSONHelper.ROLE));
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        RichTextComment comment = (RichTextComment)parameters.get("forumthreadcomment");
        activity.setValue(COMMENT_ID, (Object)comment.getId());
        activity.setValue(COMMENT_AUTHOR, (Object)comment.getAuthor());
        activity.setValue(COMMENT_AUTHOR_NAME, (Object)comment.getAuthorName());
        activity.setValue(COMMENT_CREATIONDATE, (Object)comment.getCreationDate());
        String textContent = this._threadJSONHelper.richTextToSimpleText(comment.getRichTextContent(), 150);
        activity.setValue(CONTENT, (Object)textContent);
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        return false;
    }
}

