/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class TasksActivityType
extends AbstractWorkspacesActivityType {
    public static final String ACIVITY_CATEGORY_TASKS = "tasks";
    public static final String TASK_TITLE = "taskTitle";
    public static final String TASK_ID = "taskId";
    public static final String ATTACHEMENTS_COUNT = "nbAttachments";
    private TasksWorkspaceModule _taskModule;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._taskModule = (TasksWorkspaceModule)moduleManagerEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        activity.setValue("category", (Object)ACIVITY_CATEGORY_TASKS);
        Task task = (Task)parameters.get("task");
        activity.setValue(TASK_TITLE, (Object)task.getLabel());
        activity.setValue(TASK_ID, (Object)task.getId());
        activity.setValue(ATTACHEMENTS_COUNT, (Object)task.getAttachments().size());
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        if (!"task.deleting".equals(activity.getEventType()) && activity.hasValue(TASK_ID)) {
            String taskId = (String)activity.getValue(TASK_ID);
            json.put("taskUrl", this._taskModule.getTaskUri(project, taskId));
        } else {
            json.put("taskUrl", this._taskModule.getModuleUrl(project));
        }
        return json;
    }

    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map mergedActivities = super.mergeActivities(activities);
        ArrayList tasks = new ArrayList();
        for (Activity event : activities) {
            Map json = event.toJSONForClient();
            HashMap eventInfo = new HashMap();
            eventInfo.put(TASK_TITLE, json.get(TASK_TITLE));
            eventInfo.put(TASK_ID, json.get(TASK_ID));
            eventInfo.put("taskUrl", json.get("taskUrl"));
            tasks.add(eventInfo);
        }
        mergedActivities.put(ACIVITY_CATEGORY_TASKS, tasks);
        return mergedActivities;
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        return new StringExpression(TASK_TITLE, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        Task task = (Task)args.get("task");
        return this.getParentProject((AmetysObject)task);
    }

    public boolean isGenericTaskActivityType() {
        return true;
    }
}

