/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.ResourcesArchiverHelper;
import org.ametys.plugins.contentio.archive.SystemViewHandler;
import org.ametys.plugins.contentio.archive.UnitaryImporter;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProjectArchiverHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ProjectArchiverHelper.class.getName();
    private static final String __RESOURCES_NODE_NAME = "ametys-internal:resources";
    private static final String __PROJECTS_NODE_NAME = "projects";
    private static final String __MODULE_ARCHIVE_FILENAME = "module.xml";
    private static final String __PROJECT_ARCHIVE_FILE = "project.xml";
    protected AmetysObjectResolver _resolver;
    protected ResourcesArchiverHelper _resourcesArchiverHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._resourcesArchiverHelper = (ResourcesArchiverHelper)manager.lookup(ResourcesArchiverHelper.ROLE);
    }

    public void exportProject(Project project, ZipOutputStream zos, String prefix) throws IOException {
        try {
            ZipEntry projectEntry = new ZipEntry(prefix + __PROJECT_ARCHIVE_FILE);
            zos.putNextEntry(projectEntry);
            TransformerHandler handler = Archivers.newTransformerHandler();
            handler.setResult(new StreamResult(zos));
            javax.jcr.Node projectNode = project.getNode();
            projectNode.getSession().exportSystemView(projectNode.getPath(), (ContentHandler)new SystemViewHandler((ContentHandler)handler, name -> __RESOURCES_NODE_NAME.equals(name), __ -> false), false, false);
            if (projectNode.hasNode(__RESOURCES_NODE_NAME)) {
                javax.jcr.Node resources = projectNode.getNode(__RESOURCES_NODE_NAME);
                String modulePrefix = prefix + resources.getName() + "/";
                NodeIterator moduleIterator = resources.getNodes();
                while (moduleIterator.hasNext()) {
                    javax.jcr.Node moduleNode = moduleIterator.nextNode();
                    String name2 = moduleNode.getName();
                    if ("documents".equals(name2)) {
                        ResourceCollection documentRoot = (ResourceCollection)this._resolver.resolve(moduleNode, false);
                        this._resourcesArchiverHelper.exportCollection(documentRoot, zos, modulePrefix + name2 + "/");
                        continue;
                    }
                    ZipEntry moduleEntry = new ZipEntry(modulePrefix + name2 + "/module.xml");
                    zos.putNextEntry(moduleEntry);
                    moduleNode.getSession().exportSystemView(moduleNode.getPath(), (ContentHandler)new SystemViewHandler((ContentHandler)handler, __ -> false, __ -> false), false, false);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to archive project " + project.getName(), e);
        }
    }

    public ImportReport importProjects(javax.jcr.Node pluginNode, Path zipPath, String baseImportProjectsPath, Merger merger) throws IOException {
        ImportReport report = new ImportReport();
        if (ZipEntryHelper.zipEntryFolderExists((Path)zipPath, (String)baseImportProjectsPath)) {
            try {
                javax.jcr.Node projectsNode = pluginNode.hasNode(__PROJECTS_NODE_NAME) ? pluginNode.getNode(__PROJECTS_NODE_NAME) : pluginNode.addNode(__PROJECTS_NODE_NAME, "ametys:unstructured");
                ProjectImporter projectImporter = new ProjectImporter(zipPath, projectsNode, merger, report);
                try (DirectoryStream projectPaths = ZipEntryHelper.children((Path)zipPath, Optional.of(baseImportProjectsPath.toString()), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                    for (Path projectPath : projectPaths) {
                        projectImporter.unitaryImport(zipPath, projectPath, merger, this.getLogger());
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }
        return report;
    }

    private Project _createProject(Path projectZipPath, Path zipPath, javax.jcr.Node projectsNode, Merger merger) throws IOException, Archivers.AmetysObjectNotImportedException {
        Path projectData = projectZipPath.resolve(__PROJECT_ARCHIVE_FILE);
        try {
            Session session = projectsNode.getSession();
            String parentAbsPath = projectsNode.getPath();
            this.getLogger().info("XML from '{}!{}' will be imported to '{}' with implementation of merger '{}'", new Object[]{zipPath, projectData.toString(), parentAbsPath, merger});
            try (InputStream in = ZipEntryHelper.zipEntryFileInputStream((Path)zipPath, (String)projectData.toString());){
                merger.jcrImportXml(session, parentAbsPath, in);
            }
            Archivers.unitarySave((javax.jcr.Node)projectsNode, (Logger)this.getLogger());
            javax.jcr.Node projectNode = projectsNode.getNode(projectZipPath.getFileName().toString());
            this._importModules(projectZipPath, zipPath, merger, session, projectNode);
            return (Project)this._resolver.resolve(projectNode, false);
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    private void _importModules(Path projectZipPath, Path zipPath, Merger merger, Session session, javax.jcr.Node projectNode) throws IOException, RepositoryException {
        Path modulesEntryPath = projectZipPath.resolve(__RESOURCES_NODE_NAME);
        if (ZipEntryHelper.zipEntryFolderExists((Path)zipPath, (String)modulesEntryPath.toString())) {
            javax.jcr.Node modulesRoot = projectNode.hasNode(__RESOURCES_NODE_NAME) ? projectNode.getNode(__RESOURCES_NODE_NAME) : projectNode.addNode(__RESOURCES_NODE_NAME, "ametys:resources-collection");
            try (DirectoryStream moduleEntries = ZipEntryHelper.children((Path)zipPath, Optional.of(modulesEntryPath.toString()), x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path moduleEntryPath : moduleEntries) {
                    if ("documents".equals(moduleEntryPath.getFileName().toString())) {
                        this._resourcesArchiverHelper.importCollection(moduleEntryPath.toString() + "/", modulesRoot, zipPath, merger);
                        continue;
                    }
                    InputStream moduleIn = ZipEntryHelper.zipEntryFileInputStream((Path)zipPath, (String)moduleEntryPath.resolve(__MODULE_ARCHIVE_FILENAME).toString());
                    try {
                        this.getLogger().info("XML from '{}!{}' will be imported to '{}' with implementation of merger '{}'", new Object[]{zipPath, moduleEntryPath.toString(), modulesRoot.getPath().toString(), merger});
                        merger.jcrImportXml(session, modulesRoot.getPath(), moduleIn);
                        session.save();
                    }
                    finally {
                        if (moduleIn == null) continue;
                        moduleIn.close();
                    }
                }
            }
        }
    }

    protected class ProjectImporter
    implements UnitaryImporter<Project> {
        private DocumentBuilder _builder;
        private Path _zipPath;
        private Merger _merger;
        private javax.jcr.Node _projectsNode;
        private ImportReport _report;

        public ProjectImporter(Path zipPath, javax.jcr.Node projectsNode, Merger merger, ImportReport report) throws ParserConfigurationException {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            this._builder = builderFactory.newDocumentBuilder();
            this._merger = merger;
            this._projectsNode = projectsNode;
            this._zipPath = zipPath;
            this._report = report;
        }

        public String objectNameForLogs() {
            return "Project";
        }

        public Document getPropertiesXml(Path projectPath) throws Exception {
            Document document;
            block8: {
                String propertiesPath = projectPath.resolve(ProjectArchiverHelper.__PROJECT_ARCHIVE_FILE).toString();
                InputStream stream = ZipEntryHelper.zipEntryFileInputStream((Path)this._zipPath, (String)propertiesPath);
                try {
                    Document doc;
                    document = doc = this._builder.parse(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                }
                stream.close();
            }
            return document;
        }

        public String retrieveId(Document propertiesXml) throws Exception {
            return "project://" + Archivers.xpathEvalNonEmpty((String)"sv:node/sv:property[@sv:name='jcr:uuid']/sv:value", (Node)propertiesXml);
        }

        public Project create(Path projectZipPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, ImportGlobalFailException, Exception {
            return ProjectArchiverHelper.this._createProject(projectZipPath, this._zipPath, this._projectsNode, this._merger);
        }

        public ImportReport getReport() {
            return this._report;
        }
    }
}

