/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.ActionResultGenerator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarDAO;
import org.ametys.plugins.workspaces.calendars.helper.RecurrentEventHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetCalendarEvents
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected CalendarDAO _calendarDAO;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._calendarDAO = (CalendarDAO)((Object)smanager.lookup(CalendarDAO.ROLE));
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String icsToken = parameters.getParameter("icsToken");
        Calendar calendar = this._calendarDAO.getCalendarFromIcsToken(icsToken);
        if (calendar != null) {
            List<Integer> workingDayStrings = RecurrentEventHelper.getWorkingDays();
            ArrayList<String> icsWorkingDays = new ArrayList<String>();
            for (Integer day : workingDayStrings) {
                switch (day) {
                    case 2: {
                        icsWorkingDays.add("MO");
                        break;
                    }
                    case 3: {
                        icsWorkingDays.add("TU");
                        break;
                    }
                    case 4: {
                        icsWorkingDays.add("WE");
                        break;
                    }
                    case 5: {
                        icsWorkingDays.add("TH");
                        break;
                    }
                    case 6: {
                        icsWorkingDays.add("FR");
                        break;
                    }
                    case 7: {
                        icsWorkingDays.add("SA");
                        break;
                    }
                    case 1: {
                        icsWorkingDays.add("SU");
                        break;
                    }
                }
            }
            Map<String, Object> calendarMap = this._calendarDAO.getCalendarData(calendar, true, true, true);
            result.put("calendar", calendarMap);
            result.put("workingDays", icsWorkingDays);
        }
        request.setAttribute(ActionResultGenerator.MAP_REQUEST_ATTR, result);
        return EMPTY_MAP;
    }
}

