/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.helper;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.runtime.config.Config;

public final class RecurrentEventHelper {
    private RecurrentEventHelper() {
    }

    public static ZonedDateTime getNextDate(EventRecurrenceTypeEnum recurrenceType, ZonedDateTime eventStartDate, ZonedDateTime date) {
        ZonedDateTime nextDate = null;
        switch (recurrenceType) {
            case ALL_DAY: {
                nextDate = RecurrentEventHelper._nextAllDayDate(date);
                break;
            }
            case ALL_WORKING_DAY: {
                nextDate = RecurrentEventHelper._nextAllWorkingDayDate(date);
                break;
            }
            case WEEKLY: {
                nextDate = RecurrentEventHelper._nextWeeklyDate(date);
                break;
            }
            case BIWEEKLY: {
                nextDate = RecurrentEventHelper._nextBiweeklyDate(date);
                break;
            }
            case MONTHLY: {
                nextDate = RecurrentEventHelper._nextMonthlyDate(date, eventStartDate);
                break;
            }
        }
        return nextDate;
    }

    private static ZonedDateTime _nextAllDayDate(ZonedDateTime date) {
        return date.plusDays(1L);
    }

    public static List<Integer> getWorkingDays() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String workingDayAsString = (String)Config.getInstance().getValue("workspaces.calendar.event.working.day");
        List<String> workingDaysStrings = Arrays.asList(workingDayAsString.split(","));
        for (String workkingDayString : workingDaysStrings) {
            result.add(Integer.valueOf(workkingDayString));
        }
        return result;
    }

    private static ZonedDateTime _nextAllWorkingDayDate(ZonedDateTime date) {
        String workingDayAsString = (String)Config.getInstance().getValue("workspaces.calendar.event.working.day");
        int dayId = date.getDayOfWeek().getValue() + 1;
        int nbDay = 1;
        int nextDayId = dayId % 7 + 1;
        List<String> workingDay = Arrays.asList(workingDayAsString.split(","));
        while (!workingDay.contains(String.valueOf(nextDayId))) {
            nextDayId = nextDayId % 7 + 1;
            ++nbDay;
        }
        return date.plusDays(nbDay);
    }

    private static ZonedDateTime _nextWeeklyDate(ZonedDateTime date) {
        return date.plusWeeks(1L);
    }

    private static ZonedDateTime _nextBiweeklyDate(ZonedDateTime date) {
        return date.plusWeeks(2L);
    }

    private static ZonedDateTime _nextMonthlyDate(ZonedDateTime date, ZonedDateTime eventStartDate) {
        int dayOfMonth = eventStartDate.getDayOfMonth();
        ZonedDateTime nextDate = date.plusMonths(1L);
        int nextDayOfMonth = nextDate.getDayOfMonth();
        LocalDate nextDateAsLocal = nextDate.toLocalDate();
        int nextDayMaxOfMonth = nextDateAsLocal.lengthOfMonth();
        if (nextDayOfMonth < dayOfMonth) {
            nextDate = dayOfMonth < nextDayMaxOfMonth ? nextDate.withDayOfMonth(dayOfMonth) : nextDate.withDayOfMonth(nextDayMaxOfMonth);
        }
        return nextDate;
    }

    public static List<ZonedDateTime> getOccurrences(ZonedDateTime startDate, ZonedDateTime endDate, ZonedDateTime eventStartDate, ZonedDateTime originalOccurrenceStartDate, EventRecurrenceTypeEnum recurrenceType, List<ZonedDateTime> excludedOccurences, ZoneId zoneId, ZonedDateTime untilDate) {
        long diffInSeconds = ChronoUnit.SECONDS.between(originalOccurrenceStartDate, eventStartDate);
        ArrayList<ZonedDateTime> occurences = new ArrayList<ZonedDateTime>();
        ZonedDateTime firstDate = startDate.equals(eventStartDate) ? startDate : startDate.plusSeconds(diffInSeconds);
        if ((firstDate = firstDate.withZoneSameInstant(zoneId)).isAfter(endDate)) {
            return occurences;
        }
        ZonedDateTime firstDateCalendar = firstDate.withZoneSameInstant(zoneId).truncatedTo(ChronoUnit.DAYS);
        if (excludedOccurences.stream().noneMatch(excludedOccurrence -> excludedOccurrence.isEqual(firstDateCalendar))) {
            occurences.add(firstDate);
        }
        ZonedDateTime nextDate = RecurrentEventHelper.getNextDate(recurrenceType, eventStartDate.withZoneSameInstant(zoneId), firstDate.withZoneSameInstant(zoneId));
        while (nextDate != null && nextDate.isBefore(endDate) && (untilDate == null || untilDate.isAfter(nextDate))) {
            ZonedDateTime nextDateCalendar = nextDate.truncatedTo(ChronoUnit.DAYS);
            if (excludedOccurences.stream().noneMatch(excludedOccurrence -> excludedOccurrence.isEqual(nextDateCalendar))) {
                occurences.add(nextDate);
            }
            nextDate = RecurrentEventHelper.getNextDate(recurrenceType, eventStartDate.withZoneSameInstant(zoneId), nextDate.withZoneSameInstant(zoneId));
        }
        return occurences;
    }
}

