/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.workflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.store.AmetysObjectWorkflowStore;
import org.ametys.plugins.workspaces.calendars.CalendarDAO;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventDAO;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventJSONHelper;
import org.ametys.plugins.workspaces.calendars.events.ModifiableCalendarEvent;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendar;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarEvent;
import org.ametys.plugins.workspaces.tags.ProjectTagsDAO;
import org.ametys.plugins.workspaces.workflow.AbstractNodeWorkflowComponent;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class AddEventFunction
extends AbstractNodeWorkflowComponent
implements EnhancedFunction {
    protected AmetysObjectResolver _resolver;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected ProjectTagsDAO _projectTagsDAO;
    protected CalendarDAO _calendarDAO;
    protected CalendarEventDAO _calendarEventDAO;
    protected CalendarEventJSONHelper _calendarEventJSONHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._projectTagsDAO = (ProjectTagsDAO)((Object)smanager.lookup(ProjectTagsDAO.ROLE));
        this._calendarDAO = (CalendarDAO)((Object)smanager.lookup(CalendarDAO.ROLE));
        this._calendarEventDAO = (CalendarEventDAO)((Object)smanager.lookup(CalendarEventDAO.ROLE));
        this._calendarEventJSONHelper = (CalendarEventJSONHelper)((Object)smanager.lookup(CalendarEventJSONHelper.ROLE));
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Map jsParameters = (Map)transientVars.get("parameters");
        if (jsParameters == null) {
            throw new WorkflowException("Missing JS parameters");
        }
        ExplorerNode object = this.getExplorerNode(transientVars);
        String parentId = (String)jsParameters.get("parentId");
        UserIdentity user = this.getUser(transientVars);
        String selectedNode = (String)jsParameters.get("selectedNode");
        Map result = (Map)transientVars.get("result");
        assert (parentId != null);
        if (!(object instanceof JCRCalendar)) {
            throw new IllegalArgumentException("Cannot add an event on a non-modifiable calendar '" + object.getId() + "'");
        }
        JCRCalendar modifiableCalendar = (JCRCalendar)object;
        JCRCalendarEvent event = (JCRCalendarEvent)modifiableCalendar.createChild("ametys:calendar-event", "ametys:calendar-event");
        ZonedDateTime now = ZonedDateTime.now();
        event.setCreationDate(now);
        event.setLastModified(now);
        event.setCreator(user);
        this._setEventData(event, transientVars, jsParameters);
        this._initializeWorkflow(event, transientVars, jsParameters);
        modifiableCalendar.saveChanges();
        transientVars.put("eventId", event.getId());
        result.put("id", event.getId());
        result.put("parentId", selectedNode == null ? parentId : selectedNode);
        result.put("event", this._calendarEventJSONHelper.eventAsJsonWithOccurrences(event, false, event.getStartDate(), event.getEndDate()));
        this._notifyListeners(event);
    }

    protected void _initializeWorkflow(JCRCalendarEvent event, Map transientVars, Map<String, Object> jsParameters) throws WorkflowException {
        long workflowId = ((WorkflowEntry)transientVars.get("entry")).getId();
        try {
            event.setWorkflowId(workflowId);
            WorkflowStore workflowStore = (WorkflowStore)transientVars.get("store");
            if (workflowStore instanceof AmetysObjectWorkflowStore) {
                AmetysObjectWorkflowStore ametysObjectWorkflowStore = (AmetysObjectWorkflowStore)workflowStore;
                ametysObjectWorkflowStore.bindAmetysObject((WorkflowAwareAmetysObject)event);
            }
        }
        catch (StoreException e) {
            throw new WorkflowException("Unable to link the workflow to the content", (Throwable)e);
        }
    }

    protected void _setEventData(ModifiableCalendarEvent event, Map transientVars, Map<String, Object> jsParameters) throws WorkflowException {
        Map result = (Map)transientVars.get("result");
        String title = (String)jsParameters.get("title");
        String desc = (String)jsParameters.get("description");
        String startDateAsString = (String)jsParameters.get("startDate");
        String zoneId = (String)jsParameters.get("zoneId");
        ZoneId zone = ZoneId.of(zoneId);
        event.setZone(zone);
        ZonedDateTime startDate = DateUtils.parseZonedDateTime((String)startDateAsString).withZoneSameInstant(zone);
        String endDateAsString = (String)jsParameters.get("endDate");
        ZonedDateTime endDate = DateUtils.parseZonedDateTime((String)endDateAsString).withZoneSameInstant(zone);
        Object rawFullDay = jsParameters.get("fullDay");
        Boolean fullDay = rawFullDay instanceof Boolean ? (Boolean)rawFullDay : Boolean.parseBoolean((String)rawFullDay);
        String recurrenceType = (String)jsParameters.get("recurrenceType");
        String untilDateAsString = (String)jsParameters.get("untilDate");
        ZonedDateTime untilDate = DateUtils.parseZonedDateTime((String)untilDateAsString);
        UserIdentity user = this.getUser(transientVars);
        event.setTitle(title);
        event.setDescription(desc);
        event.setFullDay(fullDay);
        event.setStartDate(startDate);
        event.setLastContributor(user);
        event.setLastModified(ZonedDateTime.now());
        event.setRecurrenceType(recurrenceType);
        if (untilDate != null) {
            event.setRepeatUntil(untilDate);
        }
        event.setEndDate(endDate);
        String location = (String)jsParameters.get("location");
        if (StringUtils.isNotEmpty((String)location)) {
            event.setLocation(location);
        }
        List tags = jsParameters.getOrDefault("tags", new ArrayList());
        ArrayList<String> createdTags = new ArrayList<String>();
        ArrayList createdTagsJson = new ArrayList();
        for (Object tag : tags) {
            if (tag instanceof Map) {
                String tagText = (String)((Map)tag).get("text");
                List newTags = this._projectTagsDAO.addTags(new String[]{tagText});
                String newTag = (String)((Map)newTags.get(0)).get("name");
                event.tag(newTag);
                createdTags.add(newTag);
                createdTagsJson.addAll(newTags);
                continue;
            }
            event.tag((String)tag);
        }
        for (Object tag : event.getTags()) {
            if (tags.contains(tag) || createdTags.contains(tag)) continue;
            event.untag((String)tag);
        }
        List resources = jsParameters.getOrDefault("resourceIds", new ArrayList());
        event.setResources(resources);
        result.put("newTags", createdTagsJson);
    }

    protected void _notifyListeners(CalendarEvent event) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("calendar", event.getCalendar());
        eventParams.put("calendar.event", event);
        eventParams.put("object.id", event.getId());
        eventParams.put("object.parent", event.getParent().getId());
        this._observationManager.notify(new Event("calendar.event.created", this._currentUserProvider.getUser(), eventParams));
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.PRE;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_ADD_EVENT_FUNCTION_LABEL");
    }
}

