/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.cmis;

import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.workspaces.cmis.CmisContentRangeInputStream;
import org.ametys.plugins.workspaces.cmis.CmisServiceFactory;
import org.ametys.plugins.workspaces.cmis.CmisUtils;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AllowableActionsImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PartialContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public class CmisRepository {
    private static final String USER_UNKNOWN = "<unknown>";

    public RepositoryInfo getRepositoryInfo(CallContext context, Project project, CmisServiceFactory factory) {
        String id = project.getId();
        String name = project.getName();
        if (id == null || id.trim().length() == 0 || name == null || name.trim().length() == 0) {
            throw new CmisInvalidArgumentException("Invalid repository!");
        }
        return this.createRepositoryInfo(project, factory, CmisVersion.CMIS_1_1);
    }

    private RepositoryInfo createRepositoryInfo(Project project, CmisServiceFactory factory, CmisVersion cmisVersion) {
        assert (cmisVersion != null);
        RepositoryInfoImpl repositoryInfo = new RepositoryInfoImpl();
        String id = project.getId();
        ModifiableResourceCollection documentRoot = this.getRoot(project, factory);
        String root = "";
        if (documentRoot != null) {
            root = documentRoot.getId();
        }
        id = URIUtils.encodeParameter((String)URIUtils.encodeParameter((String)id));
        root = URIUtils.encodeParameter((String)URIUtils.encodeParameter((String)root));
        repositoryInfo.setId(id);
        repositoryInfo.setName(project.getName());
        repositoryInfo.setDescription(project.getDescription());
        repositoryInfo.setCmisVersionSupported(cmisVersion.value());
        repositoryInfo.setProductName("Ametys CMIS Server");
        repositoryInfo.setProductVersion("1.0");
        repositoryInfo.setVendorName("Ametys");
        repositoryInfo.setRootFolder(root);
        repositoryInfo.setThinClientUri("");
        repositoryInfo.setChangesIncomplete(Boolean.valueOf(false));
        RepositoryCapabilitiesImpl capabilities = new RepositoryCapabilitiesImpl();
        capabilities.setCapabilityAcl(CapabilityAcl.NONE);
        capabilities.setAllVersionsSearchable(Boolean.valueOf(false));
        capabilities.setCapabilityJoin(CapabilityJoin.NONE);
        capabilities.setSupportsMultifiling(Boolean.valueOf(false));
        capabilities.setSupportsUnfiling(Boolean.valueOf(false));
        capabilities.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        capabilities.setIsPwcSearchable(Boolean.valueOf(false));
        capabilities.setIsPwcUpdatable(Boolean.valueOf(false));
        capabilities.setCapabilityChanges(CapabilityChanges.NONE);
        capabilities.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        capabilities.setSupportsGetDescendants(Boolean.valueOf(false));
        capabilities.setSupportsGetFolderTree(Boolean.valueOf(false));
        capabilities.setCapabilityRendition(CapabilityRenditions.NONE);
        repositoryInfo.setCapabilities((RepositoryCapabilities)capabilities);
        return repositoryInfo;
    }

    public TypeDefinition getTypeDefinition(CallContext context, String typeId, CmisServiceFactory factory) {
        return factory.getTypeManager().getTypeDefinition(context, typeId);
    }

    public TypeDefinitionList getTypeChildren(CallContext context, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, CmisServiceFactory factory) {
        return factory.getTypeManager().getTypeChildren(context, typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public ObjectData getObject(CallContext context, Project project, String objectId, String versionServicesId, String filter, Boolean includeAllowableActions, Boolean includeAcl, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        if (objectId == null && versionServicesId == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        AmetysObject ametysObject = factory.getResolver().resolveById(objectId);
        boolean userReadOnly = false;
        boolean iaa = CmisUtils.getBooleanParameter(includeAllowableActions, false);
        boolean iacl = false;
        Set<String> filterCollection = CmisUtils.splitFilter(filter);
        return this.compileObjectData(context, ametysObject, project, filterCollection, iaa, iacl, userReadOnly, objectInfos, factory);
    }

    private ObjectData compileObjectData(CallContext context, AmetysObject ametysObject, Project project, Set<String> filter, boolean includeAllowableActions, boolean includeAcl, boolean userReadOnly, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        ObjectDataImpl result = new ObjectDataImpl();
        ObjectInfoImpl objectInfo = new ObjectInfoImpl();
        result.setProperties(this.compileProperties(context, ametysObject, project, filter, objectInfo, factory));
        if (includeAllowableActions) {
            result.setAllowableActions(this.compileAllowableActions(ametysObject, project, factory, userReadOnly));
        }
        if (includeAcl) {
            result.setIsExactAcl(Boolean.valueOf(true));
        }
        result.setIsExactAcl(Boolean.valueOf(true));
        if (context.isObjectInfoRequired()) {
            objectInfo.setObject((ObjectData)result);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return result;
    }

    private Properties compileProperties(CallContext context, AmetysObject ametysObject, Project project, Set<String> orgfilter, ObjectInfoImpl objectInfo, CmisServiceFactory factory) {
        HashSet<String> filter = orgfilter == null ? null : new HashSet<String>(orgfilter);
        String typeId = null;
        Boolean isFolder = true;
        if (ametysObject != null && ametysObject instanceof ModifiableResource) {
            isFolder = false;
            typeId = BaseTypeId.CMIS_DOCUMENT.value();
            objectInfo.setBaseType(BaseTypeId.CMIS_DOCUMENT);
            objectInfo.setTypeId(typeId);
            objectInfo.setHasAcl(false);
            objectInfo.setHasContent(true);
            objectInfo.setHasParent(true);
            objectInfo.setVersionSeriesId(null);
            objectInfo.setIsCurrentVersion(true);
            objectInfo.setRelationshipSourceIds(null);
            objectInfo.setRelationshipTargetIds(null);
            objectInfo.setRenditionInfos(null);
            objectInfo.setSupportsDescendants(false);
            objectInfo.setSupportsFolderTree(false);
            objectInfo.setSupportsPolicies(false);
            objectInfo.setSupportsRelationships(false);
            objectInfo.setWorkingCopyId(null);
            objectInfo.setWorkingCopyOriginalId(null);
        } else if (ametysObject != null && ametysObject instanceof ModifiableResourceCollection) {
            isFolder = true;
            typeId = BaseTypeId.CMIS_FOLDER.value();
            objectInfo.setBaseType(BaseTypeId.CMIS_FOLDER);
            objectInfo.setTypeId(typeId);
            objectInfo.setContentType(null);
            objectInfo.setFileName(null);
            objectInfo.setHasAcl(false);
            objectInfo.setHasContent(false);
            objectInfo.setVersionSeriesId(null);
            objectInfo.setIsCurrentVersion(true);
            objectInfo.setRelationshipSourceIds(null);
            objectInfo.setRelationshipTargetIds(null);
            objectInfo.setRenditionInfos(null);
            objectInfo.setSupportsDescendants(true);
            objectInfo.setSupportsFolderTree(true);
            objectInfo.setSupportsPolicies(false);
            objectInfo.setSupportsRelationships(false);
            objectInfo.setWorkingCopyId(null);
            objectInfo.setWorkingCopyOriginalId(null);
        } else {
            throw new IllegalArgumentException("Resource not found");
        }
        try {
            PropertiesImpl result = new PropertiesImpl();
            this.addPropertyId(result, typeId, filter, "cmis:objectId", ametysObject.getId(), factory);
            objectInfo.setId(ametysObject.getId());
            String name = ametysObject.getName();
            this.addPropertyString(result, typeId, filter, "cmis:name", name, factory);
            objectInfo.setName(name);
            if (isFolder.booleanValue()) {
                ModifiableResourceCollection folder = (ModifiableResourceCollection)ametysObject;
                this.addPropertyString(result, typeId, filter, "cmis:createdBy", USER_UNKNOWN, factory);
                this.addPropertyString(result, typeId, filter, "cmis:lastModifiedBy", USER_UNKNOWN, factory);
                objectInfo.setCreatedBy(USER_UNKNOWN);
                this.addPropertyString(result, typeId, filter, "cmis:description", folder.getDescription(), factory);
                this.addPropertyId(result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_FOLDER.value(), factory);
                this.addPropertyId(result, typeId, filter, "cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value(), factory);
                String path = ((ModifiableResourceCollection)ametysObject).getExplorerPath();
                ModifiableResourceCollection root = this.getRoot(project, factory);
                path = path.substring(root.getExplorerPath().length());
                if (path.length() == 0) {
                    path = "/";
                }
                this.addPropertyString(result, typeId, filter, "cmis:path", path, factory);
                if (ametysObject.equals((Object)root)) {
                    this.addPropertyId(result, typeId, filter, "cmis:parentId", null, factory);
                    objectInfo.setHasParent(false);
                } else {
                    String parentId = ametysObject.getParent().getId();
                    this.addPropertyId(result, typeId, filter, "cmis:parentId", parentId, factory);
                    objectInfo.setHasParent(true);
                }
                this.addPropertyIdList(result, typeId, filter, "cmis:allowedChildObjectTypeIds", null, factory);
            } else {
                ModifiableResource modifiableResource = (ModifiableResource)ametysObject;
                String author = modifiableResource.getCreator().getLogin();
                String contributor = modifiableResource.getLastContributor().getLogin();
                this.addPropertyString(result, typeId, filter, "cmis:createdBy", author, factory);
                this.addPropertyString(result, typeId, filter, "cmis:lastModifiedBy", contributor, factory);
                this.addPropertyString(result, typeId, filter, "cmis:description", modifiableResource.getDCDescription(), factory);
                objectInfo.setCreatedBy(author);
                Date lastModifiedDate = modifiableResource.getLastModified();
                GregorianCalendar lastModified = new GregorianCalendar();
                lastModified.setTime(lastModifiedDate);
                Date creationDate = modifiableResource.getCreationDate();
                GregorianCalendar creation = new GregorianCalendar();
                creation.setTime(creationDate);
                this.addPropertyDateTime(result, typeId, filter, "cmis:creationDate", creation, factory);
                this.addPropertyDateTime(result, typeId, filter, "cmis:lastModificationDate", lastModified, factory);
                objectInfo.setCreationDate(creation);
                objectInfo.setLastModificationDate(lastModified);
                this.addPropertyId(result, typeId, filter, "cmis:baseTypeId", BaseTypeId.CMIS_DOCUMENT.value(), factory);
                this.addPropertyId(result, typeId, filter, "cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value(), factory);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isImmutable", false, factory);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isLatestVersion", true, factory);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isMajorVersion", true, factory);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isLatestMajorVersion", true, factory);
                this.addPropertyString(result, typeId, filter, "cmis:versionLabel", modifiableResource.getName(), factory);
                this.addPropertyBoolean(result, typeId, filter, "cmis:isVersionSeriesCheckedOut", false, factory);
                this.addPropertyString(result, typeId, filter, "cmis:versionSeriesCheckedOutBy", null, factory);
                this.addPropertyString(result, typeId, filter, "cmis:versionSeriesCheckedOutId", null, factory);
                this.addPropertyString(result, typeId, filter, "cmis:checkinComment", "", factory);
                if (context.getCmisVersion() != CmisVersion.CMIS_1_0) {
                    this.addPropertyBoolean(result, typeId, filter, "cmis:isPrivateWorkingCopy", false, factory);
                }
                if (modifiableResource.getLength() == 0L) {
                    this.addPropertyBigInteger(result, typeId, filter, "cmis:contentStreamLength", null, factory);
                    this.addPropertyString(result, typeId, filter, "cmis:contentStreamMimeType", null, factory);
                    this.addPropertyString(result, typeId, filter, "cmis:contentStreamFileName", null, factory);
                    objectInfo.setHasContent(false);
                    objectInfo.setContentType(null);
                    objectInfo.setFileName(null);
                } else {
                    this.addPropertyInteger(result, typeId, filter, "cmis:contentStreamLength", modifiableResource.getLength(), factory);
                    this.addPropertyString(result, typeId, filter, "cmis:contentStreamMimeType", modifiableResource.getMimeType(), factory);
                    this.addPropertyString(result, typeId, filter, "cmis:contentStreamFileName", modifiableResource.getName(), factory);
                    objectInfo.setHasContent(true);
                    objectInfo.setContentType(modifiableResource.getMimeType());
                    objectInfo.setFileName(modifiableResource.getName());
                }
                this.addPropertyId(result, typeId, filter, "cmis:contentStreamId", null, factory);
            }
            this.addPropertyString(result, typeId, filter, "cmis:changeToken", null, factory);
            if (context.getCmisVersion() != CmisVersion.CMIS_1_0) {
                this.addPropertyString(result, typeId, filter, "cmis:description", null, factory);
                this.addPropertyIdList(result, typeId, filter, "cmis:secondaryObjectTypeIds", null, factory);
            }
            return result;
        }
        catch (CmisBaseException cbe) {
            throw cbe;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public ObjectInFolderList getChildren(CallContext context, String folderId, Project project, String filter, Boolean includeAllowableActions, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        AmetysObject ametysObject;
        int max;
        int skip;
        boolean userReadOnly = false;
        Set<String> filterCollection = CmisUtils.splitFilter(filter);
        boolean iaa = CmisUtils.getBooleanParameter(includeAllowableActions, false);
        boolean ips = CmisUtils.getBooleanParameter(includePathSegment, false);
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        if (!((ametysObject = factory.getResolver().resolveById(folderId)) instanceof ModifiableResourceCollection)) {
            throw new CmisObjectNotFoundException("Not a folder!");
        }
        ModifiableResourceCollection folder = (ModifiableResourceCollection)ametysObject;
        if (context.isObjectInfoRequired()) {
            this.compileObjectData(context, ametysObject, project, null, false, false, userReadOnly, objectInfos, factory);
        }
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        result.setObjects(new ArrayList());
        result.setHasMoreItems(Boolean.valueOf(false));
        int count = 0;
        AmetysObjectIterable children = folder.getChildren();
        for (AmetysObject child : children) {
            if (!(child instanceof ModifiableResource) && !(child instanceof ModifiableResourceCollection)) continue;
            ++count;
            if (skip > 0) {
                --skip;
                continue;
            }
            if (result.getObjects().size() >= max) {
                result.setHasMoreItems(Boolean.valueOf(true));
                continue;
            }
            ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
            objectInFolder.setObject(this.compileObjectData(context, child, project, filterCollection, iaa, false, userReadOnly, objectInfos, factory));
            if (ips) {
                objectInFolder.setPathSegment(child.getName());
            }
            result.getObjects().add(objectInFolder);
        }
        result.setNumItems(BigInteger.valueOf(count));
        return result;
    }

    public List<ObjectParentData> getObjectParents(CallContext context, String objectId, Project project, String filter, Boolean includeAllowableActions, Boolean includeRelativePathSegment, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        boolean userReadOnly = false;
        Set<String> filterCollection = CmisUtils.splitFilter(filter);
        boolean iaa = CmisUtils.getBooleanParameter(includeAllowableActions, false);
        boolean irps = CmisUtils.getBooleanParameter(includeRelativePathSegment, false);
        AmetysObject ametysObject = factory.getResolver().resolveById(objectId);
        if (this.isRoot(ametysObject, project, factory).booleanValue()) {
            return Collections.emptyList();
        }
        if (context.isObjectInfoRequired()) {
            this.compileObjectData(context, ametysObject, project, null, false, false, userReadOnly, objectInfos, factory);
        }
        AmetysObject parent = ametysObject.getParent();
        ObjectData object = this.compileObjectData(context, parent, project, filterCollection, iaa, false, userReadOnly, objectInfos, factory);
        ObjectParentDataImpl result = new ObjectParentDataImpl();
        result.setObject(object);
        if (irps) {
            result.setRelativePathSegment(ametysObject.getName());
        }
        return Collections.singletonList(result);
    }

    public ContentStream getContentStream(CallContext context, String objectId, BigInteger offset, BigInteger length, CmisServiceFactory factory) {
        AmetysObject ametysObject = factory.getResolver().resolveById(objectId);
        if (!(ametysObject instanceof ModifiableResource)) {
            throw new CmisStreamNotSupportedException("Not a file!");
        }
        ModifiableResource res = (ModifiableResource)ametysObject;
        if (res.getLength() == 0L) {
            throw new CmisConstraintException("Document has no content!");
        }
        InputStream stream = null;
        stream = res.getInputStream();
        if (offset != null || length != null) {
            stream = new CmisContentRangeInputStream(stream, offset, length);
        }
        Object result = offset != null && offset.longValue() > 0L || length != null ? new PartialContentStreamImpl() : new ContentStreamImpl();
        result.setFileName(res.getName());
        result.setLength(BigInteger.valueOf(res.getLength()));
        result.setMimeType(res.getMimeType());
        result.setStream(stream);
        return result;
    }

    public ObjectData getObjectByPath(CallContext context, Project project, String folderPath, String filter, boolean includeAllowableActions, boolean includeACL, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        boolean userReadOnly = false;
        Set<String> filterCollection = CmisUtils.splitFilter(filter);
        if (folderPath == null || folderPath.length() == 0 || folderPath.charAt(0) != '/') {
            throw new CmisInvalidArgumentException("Invalid folder path!");
        }
        ModifiableResourceCollection root = this.getRoot(project, factory);
        Object file = null;
        file = folderPath.length() == 1 ? root : factory.getResolver().resolveByPath(root.getPath() + folderPath);
        if (file == null) {
            throw new CmisObjectNotFoundException("Path doesn't exist.");
        }
        return this.compileObjectData(context, (AmetysObject)file, project, filterCollection, includeAllowableActions, includeACL, userReadOnly, objectInfos, factory);
    }

    public String createFolder(CallContext context, Properties properties, Project project, String folderId, CmisServiceFactory factory) {
        this.checkNewProperties(properties, BaseTypeId.CMIS_FOLDER, factory);
        AmetysObject ametysObject = factory.getResolver().resolveById(folderId);
        if (!(ametysObject instanceof ModifiableResourceCollection)) {
            throw new CmisObjectNotFoundException("Parent is not a folder!");
        }
        String name = CmisUtils.getStringProperty(properties, "cmis:name");
        String description = CmisUtils.getStringProperty(properties, "cmis:description", "");
        Map<String, Object> addFolder = factory.getWorkspaceExplorerResourceDAO().addFolder(folderId, name, description, true);
        return (String)addFolder.get("id");
    }

    public String createDocument(CallContext context, Properties properties, Project project, String folderId, ContentStream contentStream, VersioningState versioningState, CmisServiceFactory factory) {
        if (VersioningState.NONE != versioningState) {
            throw new CmisConstraintException("Versioning not supported!");
        }
        this.checkNewProperties(properties, BaseTypeId.CMIS_DOCUMENT, factory);
        String name = CmisUtils.getStringProperty(properties, "cmis:name");
        ResourceCollection collection = (ResourceCollection)factory.getResolver().resolveById(folderId);
        if (!(collection instanceof ModifiableResourceCollection)) {
            throw new IllegalArgumentException("Cannot create file on a non modifiable folder '" + folderId + "'");
        }
        ModifiableResourceCollection mCollection = (ModifiableResourceCollection)collection;
        factory.getAddOrUpdateResourceHelper().checkAddResourceRight(mCollection);
        AddOrUpdateResourceHelper.ResourceOperationResult resourceOperation = factory.getAddOrUpdateResourceHelper().performResourceOperation(contentStream.getStream(), name, mCollection, AddOrUpdateResourceHelper.ResourceOperationMode.ADD_RENAME);
        if (!resourceOperation.isSuccess()) {
            throw new CmisStorageException("Could not create file: " + resourceOperation.getErrorMessage());
        }
        String id = resourceOperation.getResource().getId();
        return id;
    }

    public void deleteObject(CallContext context, String objectId, CmisServiceFactory factory) {
        ArrayList<String> toDelete = new ArrayList<String>(1);
        toDelete.add(objectId);
        Map deleted = factory.getWorkspaceExplorerResourceDAO().deleteObject(toDelete);
        if (deleted.containsKey("message")) {
            throw new CmisStorageException("Deletion failed : " + String.valueOf(deleted.get("message")));
        }
    }

    public ObjectData getFolderParent(CallContext context, Project project, String folderId, String filter, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        boolean userReadOnly = false;
        AmetysObject ametysObject = factory.getResolver().resolveById(folderId);
        if (this.isRoot(ametysObject, project, factory).booleanValue()) {
            throw new CmisInvalidArgumentException("The root folder has no parent!");
        }
        AmetysObject parent = ametysObject.getParent();
        Set<String> filterCollection = CmisUtils.splitFilter(filter);
        ObjectData object = this.compileObjectData(context, parent, project, filterCollection, false, false, userReadOnly, objectInfos, factory);
        return object;
    }

    public FailedToDeleteData deleteTree(CallContext context, Project project, String folderId, CmisServiceFactory factory) {
        AmetysObject ametysObject = factory.getResolver().resolveById(folderId);
        if (ametysObject instanceof ModifiableResourceCollection) {
            ModifiableResourceCollection folder = (ModifiableResourceCollection)ametysObject;
            AmetysObjectIterable children = folder.getChildren();
            ArrayList<String> toDelete = new ArrayList<String>();
            for (AmetysObject child : children) {
                toDelete.add(child.getId());
            }
            Map deletedMsg = factory.getWorkspaceExplorerResourceDAO().deleteObject(toDelete);
            if (deletedMsg.containsKey("message")) {
                throw new CmisStorageException("Deletion failed : " + String.valueOf(deletedMsg.get("message")));
            }
        } else {
            throw new CmisConstraintException("Object is not a folder!");
        }
        FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
        result.setIds(new ArrayList());
        return result;
    }

    public ObjectData updateProperties(CallContext context, Project project, Holder<String> objectIdHolder, Properties properties, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        if (objectIdHolder == null || objectIdHolder.getValue() == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        String objectId = (String)objectIdHolder.getValue();
        boolean userReadOnly = false;
        AmetysObject ametysObject = factory.getResolver().resolveById(objectId);
        if (ametysObject != null && ametysObject instanceof ModifiableResource) {
            ModifiableResource resource = (ModifiableResource)ametysObject;
            String inputName = CmisUtils.getStringProperty(properties, "cmis:name", resource.getName());
            String description = CmisUtils.getStringProperty(properties, "cmis:description", resource.getDCDescription());
            ArrayList<String> tags = new ArrayList<String>(Arrays.asList(resource.getKeywords()));
            factory.getWorkspaceExplorerResourceDAO().editFile(objectId, inputName, description, tags);
        } else if (ametysObject != null && ametysObject instanceof ModifiableResourceCollection) {
            ModifiableResourceCollection folder = (ModifiableResourceCollection)ametysObject;
            String inputName = CmisUtils.getStringProperty(properties, "cmis:name", folder.getName());
            String description = CmisUtils.getStringProperty(properties, "cmis:description", folder.getDescription());
            if (description == null) {
                description = "";
            }
            factory.getWorkspaceExplorerResourceDAO().editFolder(objectId, inputName, description);
        } else {
            throw new CmisObjectNotFoundException("File not found!");
        }
        AmetysObject modified = factory.getResolver().resolveById(objectId);
        return this.compileObjectData(context, modified, project, null, false, false, userReadOnly, objectInfos, factory);
    }

    public void changeContentStream(CallContext context, Project project, Holder<String> objectIdHolder, Boolean overwriteFlag, ContentStream contentStream, boolean append, CmisServiceFactory factory) {
        if (objectIdHolder == null || objectIdHolder.getValue() == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        String objectId = (String)objectIdHolder.getValue();
        AmetysObject ametysObject = factory.getResolver().resolveById(objectId);
        boolean owf = CmisUtils.getBooleanParameter(overwriteFlag, true);
        if (!owf && contentStream.getLength() > 0L) {
            throw new CmisContentAlreadyExistsException("Content already exists!");
        }
        if (ametysObject instanceof ModifiableResource) {
            factory.getAddOrUpdateResourceHelper().checkAddResourceRight((ModifiableResourceCollection)ametysObject);
            String name = ametysObject.getName();
            AddOrUpdateResourceHelper.ResourceOperationResult resourceOperation = factory.getAddOrUpdateResourceHelper().performResourceOperation(contentStream.getStream(), name, (ModifiableResourceCollection)ametysObject.getParent(), AddOrUpdateResourceHelper.ResourceOperationMode.UPDATE);
            if (!resourceOperation.isSuccess()) {
                throw new CmisRuntimeException("Impossible to update file : " + resourceOperation.getErrorMessage());
            }
        } else {
            throw new CmisObjectNotFoundException("File not found!");
        }
    }

    public ObjectData moveObject(CallContext context, Project project, Holder<String> objectId, String targetFolderId, ObjectInfoHandler objectInfos, CmisServiceFactory factory) {
        boolean userReadOnly = false;
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        ArrayList<String> documentIds = new ArrayList<String>(1);
        documentIds.add((String)objectId.getValue());
        try {
            Map<String, Object> result = factory.getWorkspaceExplorerResourceDAO().moveDocuments(documentIds, targetFolderId);
            if (result.containsKey("message")) {
                throw new CmisStorageException((String)result.get("message"));
            }
            AmetysObject ametysObject = factory.getResolver().resolveById((String)objectId.getValue());
            return this.compileObjectData(context, ametysObject, project, null, false, false, userReadOnly, objectInfos, factory);
        }
        catch (RepositoryException e) {
            throw new CmisStorageException("Impossible to move file", (Throwable)e);
        }
    }

    private void checkNewProperties(Properties properties, BaseTypeId baseTypeId, CmisServiceFactory factory) {
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        String typeId = CmisUtils.getObjectTypeId(properties);
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type Id is not set!");
        }
        TypeDefinition type = factory.getTypeManager().getInternalTypeDefinition(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        if (type.getBaseTypeId() != baseTypeId) {
            if (baseTypeId == BaseTypeId.CMIS_DOCUMENT) {
                throw new CmisInvalidArgumentException("Type is not a document type!");
            }
            if (baseTypeId == BaseTypeId.CMIS_DOCUMENT) {
                throw new CmisInvalidArgumentException("Type is not a folder type!");
            }
            throw new CmisRuntimeException("A file system does not support a " + baseTypeId.value() + " type!");
        }
        this.checkTypeProperties(properties, typeId, factory, true);
        for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
            if (!propDef.isRequired().booleanValue() || properties.getProperties().containsKey(propDef.getId()) || propDef.getUpdatability() == Updatability.READONLY) continue;
            throw new CmisConstraintException("Property '" + propDef.getId() + "' is required!");
        }
    }

    private void checkTypeProperties(Properties properties, String typeId, CmisServiceFactory factory, boolean isCreate) {
        TypeDefinition type = factory.getTypeManager().getInternalTypeDefinition(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        for (PropertyData prop : properties.getProperties().values()) {
            PropertyDefinition propType = (PropertyDefinition)type.getPropertyDefinitions().get(prop.getId());
            if (propType == null) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is unknown!");
            }
            if (propType.getUpdatability() == Updatability.READONLY) {
                throw new CmisConstraintException("Property '" + prop.getId() + "' is readonly!");
            }
            if (isCreate || propType.getUpdatability() != Updatability.ONCREATE) continue;
            throw new CmisConstraintException("Property '" + prop.getId() + "' cannot be updated!");
        }
    }

    private void addPropertyId(PropertiesImpl props, String typeId, Set<String> filter, String id, String value, CmisServiceFactory factory) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id, factory)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyIdImpl(id, value));
    }

    private void addPropertyIdList(PropertiesImpl props, String typeId, Set<String> filter, String id, List<String> value, CmisServiceFactory factory) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id, factory)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyIdImpl(id, value));
    }

    private void addPropertyString(PropertiesImpl props, String typeId, Set<String> filter, String id, String value, CmisServiceFactory factory) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id, factory)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyStringImpl(id, value));
    }

    private void addPropertyInteger(PropertiesImpl props, String typeId, Set<String> filter, String id, long value, CmisServiceFactory factory) {
        this.addPropertyBigInteger(props, typeId, filter, id, BigInteger.valueOf(value), factory);
    }

    private void addPropertyBigInteger(PropertiesImpl props, String typeId, Set<String> filter, String id, BigInteger value, CmisServiceFactory factory) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id, factory)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyIntegerImpl(id, value));
    }

    private void addPropertyBoolean(PropertiesImpl props, String typeId, Set<String> filter, String id, boolean value, CmisServiceFactory factory) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id, factory)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyBooleanImpl(id, Boolean.valueOf(value)));
    }

    private void addPropertyDateTime(PropertiesImpl props, String typeId, Set<String> filter, String id, GregorianCalendar value, CmisServiceFactory factory) {
        if (!this.checkAddProperty((Properties)props, typeId, filter, id, factory)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyDateTimeImpl(id, value));
    }

    private boolean checkAddProperty(Properties properties, String typeId, Set<String> filter, String id, CmisServiceFactory factory) {
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must not be null!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null!");
        }
        TypeDefinition type = factory.getTypeManager().getInternalTypeDefinition(typeId);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type: " + typeId);
        }
        if (!type.getPropertyDefinitions().containsKey(id)) {
            throw new IllegalArgumentException("Unknown property: " + id);
        }
        String queryName = ((PropertyDefinition)type.getPropertyDefinitions().get(id)).getQueryName();
        if (queryName != null && filter != null) {
            if (!filter.contains(queryName)) {
                return false;
            }
            filter.remove(queryName);
        }
        return true;
    }

    private AllowableActions compileAllowableActions(AmetysObject file, Project project, CmisServiceFactory factory, boolean userReadOnly) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        boolean isReadOnly = false;
        boolean isRoot = this.isRoot(file, project, factory);
        EnumSet<Action> aas = EnumSet.noneOf(Action.class);
        this.addAction(aas, Action.CAN_GET_OBJECT_PARENTS, !isRoot);
        this.addAction(aas, Action.CAN_GET_PROPERTIES, true);
        this.addAction(aas, Action.CAN_UPDATE_PROPERTIES, !userReadOnly && !isReadOnly);
        this.addAction(aas, Action.CAN_MOVE_OBJECT, !userReadOnly && !isRoot);
        this.addAction(aas, Action.CAN_DELETE_OBJECT, !userReadOnly && !isReadOnly && !isRoot);
        this.addAction(aas, Action.CAN_GET_ACL, true);
        if (file instanceof ModifiableResourceCollection) {
            this.addAction(aas, Action.CAN_GET_DESCENDANTS, true);
            this.addAction(aas, Action.CAN_GET_CHILDREN, true);
            this.addAction(aas, Action.CAN_GET_FOLDER_PARENT, !isRoot);
            this.addAction(aas, Action.CAN_GET_FOLDER_TREE, true);
            this.addAction(aas, Action.CAN_CREATE_DOCUMENT, !userReadOnly);
            this.addAction(aas, Action.CAN_CREATE_FOLDER, !userReadOnly);
            this.addAction(aas, Action.CAN_DELETE_TREE, !userReadOnly && !isReadOnly);
        } else if (file instanceof ModifiableResource) {
            ModifiableResource res = (ModifiableResource)file;
            this.addAction(aas, Action.CAN_GET_CONTENT_STREAM, res.getLength() > 0L);
            this.addAction(aas, Action.CAN_SET_CONTENT_STREAM, !userReadOnly && !isReadOnly);
            this.addAction(aas, Action.CAN_DELETE_CONTENT_STREAM, !userReadOnly && !isReadOnly);
            this.addAction(aas, Action.CAN_GET_ALL_VERSIONS, true);
        }
        AllowableActionsImpl result = new AllowableActionsImpl();
        result.setAllowableActions(aas);
        return result;
    }

    private void addAction(Set<Action> aas, Action action, boolean condition) {
        if (condition) {
            aas.add(action);
        }
    }

    private Boolean isRoot(ModifiableResourceCollection object, Project project, DocumentWorkspaceModule documentModule) {
        ModifiableResourceCollection documentRoot = documentModule.getModuleRoot(project, false);
        return documentRoot.getId().equals(object.getId());
    }

    private Boolean isRoot(AmetysObject ametysObject, Project project, CmisServiceFactory factory) {
        if (ametysObject instanceof ModifiableResourceCollection) {
            return this.isRoot((ModifiableResourceCollection)ametysObject, project, factory.getDocumentModule());
        }
        return false;
    }

    private ModifiableResourceCollection getRoot(Project project, CmisServiceFactory factory) {
        return factory.getDocumentModule().getModuleRoot(project, false);
    }
}

