/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.generators;

import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.query.DocumentTypeQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.solr.SearcherFactory;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DocumentStreamGenerator
extends ServiceableGenerator
implements Contextualizable {
    protected ProjectManager _projectManager;
    protected ProjectMemberManager _projectMemberManager;
    protected ProjectsCatalogueManager _projectCatalogManager;
    protected DocumentWorkspaceModule _documentModule;
    protected CurrentUserProvider _currentUserProvider;
    protected SearcherFactory _searcherFactory;
    protected UserManager _userManager;
    protected UserHelper _userHelper;
    protected RightManager _rightManager;
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)serviceManager.lookup(ProjectMemberManager.ROLE));
        this._projectCatalogManager = (ProjectsCatalogueManager)((Object)serviceManager.lookup(ProjectsCatalogueManager.ROLE));
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._documentModule = (DocumentWorkspaceModule)moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._searcherFactory = (SearcherFactory)serviceManager.lookup(SearcherFactory.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        int max = this.parameters.getParameterAsInteger("max-results", 0);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"documents");
        UserIdentity user = this._currentUserProvider.getUser();
        if (user != null) {
            this._getLastDocuments(user, max).stream().forEach(this::_saxDocument);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"documents");
        this.contentHandler.endDocument();
    }

    private AmetysObjectIterable<Resource> _getLastDocuments(UserIdentity user, int max) {
        try {
            return this._searcherFactory.create().addFilterQuery((Query)new DocumentTypeQuery("projectResource")).setCheckRights(true).withLimits(0, max > 0 ? max : Integer.MAX_VALUE).withSort(new SearcherFactory.SortDefinition[]{new SearcherFactory.SortDefinition("date-for-sorting", SortOrder.DESC)}).search();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("An error occurred while requesting last documents for user '%s'.", user), e);
        }
    }

    protected void _saxDocument(Resource resource) {
        try {
            Project project = this._projectManager.getParentProject((AmetysObject)resource);
            ResourceCollection folder = (ResourceCollection)resource.getParent();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", resource.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"document", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"name", (String)resource.getName());
            attrs.clear();
            attrs.addCDATAAttribute("id", folder.getId());
            String documentUrl = this._getDocumentUrl(project, folder);
            attrs.addCDATAAttribute("url", documentUrl);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"folder", (Attributes)attrs, (String)folder.getName());
            attrs.clear();
            attrs.addCDATAAttribute("id", project.getId());
            Optional<UserIdentity> creator = Optional.ofNullable(resource.getCreator());
            attrs.addCDATAAttribute("hasAccess", String.valueOf(creator.isPresent() && this._projectMemberManager.isProjectMember(project, creator.get())));
            attrs.addCDATAAttribute("url", this._projectManager.getProjectUrl(project, ""));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs, (String)project.getTitle());
            this._projectCatalogManager.saxCategory(this.contentHandler, project, "projectCategory");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastModified", (String)DateUtils.dateToString((Date)resource.getLastModified()));
            creator.map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).ifPresent(LambdaUtils.wrapConsumer(lastContributor -> this._userHelper.saxUser(lastContributor, this.contentHandler)));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"document");
        }
        catch (SAXException e) {
            throw new RuntimeException("An error occurred while gathering the documents' information.");
        }
    }

    protected String _getDocumentUrl(Project project, ResourceCollection folder) {
        Set<Page> documentModulePages = this._projectManager.getModulePages(project, this._documentModule);
        if (!documentModulePages.isEmpty()) {
            Page documentModulePage = documentModulePages.iterator().next();
            StringBuilder sb = new StringBuilder();
            sb.append(ResolveURIComponent.resolve((String)"page", (String)documentModulePage.getId()));
            sb.append("#").append(folder.getId());
            return sb.toString();
        }
        return null;
    }
}

