/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members.observers;

import java.util.HashSet;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.plugins.userdirectory.observation.AbstractContentObserver;
import org.ametys.plugins.workspaces.members.MemberHelper;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.CollectionUtils;

public class InvalidateZoneItemCacheOnMemberModificationObserver
extends AbstractContentObserver {
    private MemberHelper _memberHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._memberHelper = (MemberHelper)((Object)smanager.lookup(MemberHelper.ROLE));
    }

    public int getPriority() {
        return 3500;
    }

    public boolean supports(Event event) {
        boolean eventSupported;
        String eventId = event.getId();
        boolean bl = eventSupported = eventId.equals("content.deleting") || eventId.equals("content.untag.live") || eventId.equals("content.validated");
        if (eventSupported) {
            Content content = (Content)event.getArguments().get("content");
            return content != null && this._contentTypeHelper.isInstanceOf(content, "org.ametys.plugins.workspaces.Content.member");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _internalObserve(Event event, Page rootUsersPage, Content userContent) {
        block7: {
            try {
                VersionableAmetysObject versionableContent;
                String[] allRevisions;
                if (!this._needCacheInvalidation(event, userContent)) break block7;
                HashSet<Content> contentsToInvalidate = new HashSet<Content>();
                List<Content> relatedMembers = this._memberHelper.getRelatedMembers(userContent, Integer.MAX_VALUE);
                contentsToInvalidate.addAll(relatedMembers);
                if (userContent instanceof VersionableAmetysObject && !event.getId().equals("content.deleting") && (allRevisions = (versionableContent = (VersionableAmetysObject)userContent).getAllRevisions()).length > 1) {
                    String lastRevision = allRevisions[allRevisions.length - 2];
                    versionableContent.switchToRevision(lastRevision);
                    try {
                        List<Content> oldRelatedMemmbers = this._memberHelper.getRelatedMembers(userContent, Integer.MAX_VALUE);
                        contentsToInvalidate.addAll(oldRelatedMemmbers);
                    }
                    finally {
                        versionableContent.switchToRevision(null);
                    }
                }
                for (Content content : contentsToInvalidate) {
                    this._removeZoneItemCache(rootUsersPage, content, null);
                }
            }
            catch (Exception e) {
                this.getLogger().error("Unable to get the related members for content '{}'. The zoneitem cache has not been invalidated.", (Object)userContent.getId(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _needCacheInvalidation(Event event, Content userContent) {
        VersionableAmetysObject versionableContent;
        String[] allRevisions;
        if (event.getId().equals("content.deleting")) {
            return true;
        }
        List<String> skills = this._memberHelper.getSkills(userContent);
        List<String> keywords = this._memberHelper.getKeywords(userContent);
        if (userContent instanceof VersionableAmetysObject && (allRevisions = (versionableContent = (VersionableAmetysObject)userContent).getAllRevisions()).length > 1) {
            String lastRevision = allRevisions[allRevisions.length - 2];
            versionableContent.switchToRevision(lastRevision);
            try {
                List<String> oldSkills = this._memberHelper.getSkills(userContent);
                List<String> oldKeywords = this._memberHelper.getKeywords(userContent);
                boolean bl = CollectionUtils.disjunction(skills, oldSkills).size() > 0 || CollectionUtils.disjunction(keywords, oldKeywords).size() > 0;
                return bl;
            }
            finally {
                versionableContent.switchToRevision(null);
            }
        }
        return false;
    }
}

