/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members.observers;

import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.observers.AbstractUpdateAclSorCacheObserver;

public class UpdateAclSolrCacheOnMemberUpdatedObserver
extends AbstractUpdateAclSorCacheObserver {
    public boolean supports(Event event) {
        String eventId = event.getId();
        return eventId.equals("member.added") || eventId.equals("member.deleted") || eventId.equals("project.updated");
    }

    @Override
    protected Expression getContentsExpression(Event event, Project project) {
        StringExpression siteExpression = new StringExpression("site", Expression.Operator.EQ, project.getSite().getName());
        ContentTypeExpression projectCTypesExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.projectArticle", "org.ametys.plugins.workspaces.Content.wallContent", "org.ametys.plugins.workspaces.Content.alert", "org.ametys.plugins.workspaces.Content.projectNews"});
        AndExpression projectExpr = new AndExpression(new Expression[]{siteExpression, projectCTypesExpr});
        ContentTypeExpression catalogCTypesExpr = new ContentTypeExpression(Expression.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.catalogNews"});
        StringExpression catalogSiteExpr = new StringExpression("site", Expression.Operator.EQ, this._projectManager.getCatalogSiteName());
        AndExpression catalogExpr = new AndExpression(new Expression[]{catalogSiteExpr, catalogCTypesExpr});
        return new OrExpression(new Expression[]{catalogExpr, projectExpr});
    }
}

