/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.cms.tag.AbstractTagProviderExtensionPoint;
import org.ametys.cms.tag.TagProvider;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProjectsCatalogueGenerator
extends ServiceableGenerator {
    protected RightProfilesDAO _rightProfilesDao;
    protected AbstractTagProviderExtensionPoint<Category> _tagProviderExtPt;
    private WorkspaceModuleExtensionPoint _modulesExtensionPoint;
    private CategoryHelper _categoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._rightProfilesDao = (RightProfilesDAO)smanager.lookup(RightProfilesDAO.ROLE);
        this._tagProviderExtPt = (AbstractTagProviderExtensionPoint)smanager.lookup(CategoryProviderExtensionPoint.ROLE);
        this._categoryHelper = (CategoryHelper)smanager.lookup(CategoryHelper.ROLE);
        this._modulesExtensionPoint = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"catalog");
        this._saxProfiles();
        this._saxCategories();
        this._saxModules();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"catalog");
        this.contentHandler.endDocument();
    }

    private void _saxModules() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"modules");
        for (WorkspaceModule workspaceModule : this._modulesExtensionPoint.getModules()) {
            if (ProjectsCatalogueManager.DEFAULT_MODULES.contains(workspaceModule.getId())) continue;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", workspaceModule.getId());
            if (workspaceModule.isUnactivatedByDefault()) {
                attrs.addCDATAAttribute("unselected", "true");
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"module", (Attributes)attrs);
            workspaceModule.getModuleTitle().toSAX(this.contentHandler, "title");
            workspaceModule.getModuleDescription().toSAX(this.contentHandler, "description");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"module");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"modules");
    }

    private void _saxCategories() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"categories");
        for (String id : this._tagProviderExtPt.getExtensionsIds()) {
            TagProvider categoryProvider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            Map tags = categoryProvider.getTags(MapUtils.EMPTY_MAP);
            for (Category category : tags.values()) {
                this._saxCategory(category);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"categories");
    }

    private void _saxCategory(Category category) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"category");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"name", (String)category.getName());
        category.getTitle().toSAX(this.contentHandler, "title");
        Map<String, String> categoryColor = this._categoryHelper.getCategoryColor(category);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)categoryColor.get("main"));
        Map<String, Category> tags = category.getTags();
        if (!tags.isEmpty()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"children");
            for (Category tag : tags.values()) {
                this._saxCategory(tag);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"children");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"category");
    }

    private void _saxProfiles() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"profiles");
        String[] authorizedProjectProfileIds = StringUtils.split((String)StringUtils.defaultString((String)((String)Config.getInstance().getValue("workspaces.profile.list"))), (String)",");
        List authorizedProjectProfile = Arrays.stream(authorizedProjectProfileIds).map(arg_0 -> ((RightProfilesDAO)this._rightProfilesDao).getProfile(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        for (Profile profile : authorizedProjectProfile) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", profile.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"profile", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)profile.getLabel());
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"profile");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"profiles");
    }
}

