/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.report;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportHelper
implements Serviceable,
Component {
    public static final String ROLE = ReportHelper.class.getName();
    public static final String REPORT_ALL_RIGHT_ID = "Workspaces_Reports_Right_Report_All";
    public static final String REPORT_SERVICE_ID = "org.ametys.plugins.workspacesReports.service.Report";
    protected CurrentUserProvider _currentUserProvider;
    protected ProjectManager _projectManager;
    protected RightManager _rightManager;
    protected CategoryProviderExtensionPoint _categoryProviderEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)manager.lookup(CategoryProviderExtensionPoint.ROLE));
    }

    public List<Project> getAvailableProjects() {
        UserIdentity user = this._currentUserProvider.getUser();
        boolean hasSuperRight = this.hasSuperRight();
        Function<Project, String> getProjectTitle = Project::getTitle;
        Comparator<Project> projectTitleComparator = Comparator.comparing(getProjectTitle.andThen(StringUtils::stripAccents), String.CASE_INSENSITIVE_ORDER);
        return this._projectManager.getProjects().stream().filter(p -> hasSuperRight || ArrayUtils.contains((Object[])p.getManagers(), (Object)user)).sorted(projectTitleComparator).collect(Collectors.toList());
    }

    public boolean hasSuperRight() {
        return this.hasSuperRight(this._currentUserProvider.getUser());
    }

    public boolean hasSuperRight(UserIdentity user) {
        return this._rightManager.hasRight(user, REPORT_ALL_RIGHT_ID, (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }

    public List<Project> getAvailableProjects(List<String> filteredProjects, List<String> filteredCategories) {
        return this.getAvailableProjects().stream().filter(p -> filteredProjects == null || filteredProjects.isEmpty() || filteredProjects.contains(p.getId())).filter(p -> this._matchCategories((Project)((Object)p), filteredCategories)).collect(Collectors.toList());
    }

    private boolean _matchCategories(Project project, List<String> filteredCategories) {
        if (filteredCategories == null || filteredCategories.isEmpty()) {
            return true;
        }
        for (String projectCategory : project.getCategories()) {
            Category rootCategory;
            Category category = (Category)this._categoryProviderEP.getTag(projectCategory, null);
            if (category == null || !filteredCategories.contains((rootCategory = this._getRootCategory(category)).getName())) continue;
            return true;
        }
        return false;
    }

    public Set<Category> getAvailableCategories(List<Project> projects) {
        return projects.stream().map(Project::getCategories).flatMap(Collection::stream).map(id -> (Category)this._categoryProviderEP.getTag((String)id, null)).filter(Objects::nonNull).map(c -> this._getRootCategory((Category)c)).collect(Collectors.toSet());
    }

    private Category _getRootCategory(Category category) {
        Category parent = category;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }
}

