/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

migrateCalendars(Repository.session, "default");
migrateCalendars(Repository.liveSession, "live");
  
function migrateCalendars(s, sessionName)
{
    let count = 0;
    Repository.query("//element(*, ametys:calendar)[@ametys:visibility = 'PUBLIC']", true, s).forEach(function(calendar) {
        let calendarName = calendar.getName();
        if (calendarName === "Principal" || calendarName === "Main")
        {
            logger.info("Change visibility to private for calendar " + calendarName  + " (" + calendar.getId() + ")");
            calendar.setVisibility(org.ametys.plugins.workspaces.calendars.Calendar.CalendarVisibility.PRIVATE);
            calendar.saveChanges();
            count++;
        }
    });
    
    logger.info(count + " calendar(s) are migrated for session " + sessionName);
}
