<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:escape="org.apache.commons.lang.StringEscapeUtils"
                xmlns:math="java.lang.Math"
                xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametysProject="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                extension-element-prefixes="ametys escape math user resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="plugin:core-impl://stylesheets/vuejs/helper.xsl" /> 
    <xsl:import href="../../common.xsl"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:variable name="common-service-name">module-calendar</xsl:variable>
    
    <xsl:template name="common-service-head-title"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="common-workspaces-js"/>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', 'js/vendor/velocity/velocity.min.js')}"></script>
        
        <xsl:call-template name="vuejs-head">          
            <xsl:with-param name="component">calendar</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/calendar')"/>  
        </xsl:call-template>   
    </xsl:template>
    
    <xsl:template name="common-service-head-css">
        <xsl:call-template name="common-workspaces-css"/>
        
        <xsl:variable name="url"><xsl:value-of select="ametys:absoluteUriPrefix()" />/plugins/workspaces/<xsl:value-of select="ametys:site()" />/project-tags.min.css</xsl:variable>
        <link rel="stylesheet" href="{$url}" />
        
    </xsl:template>
        
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="vuejs">          
            <xsl:with-param name="component">calendar</xsl:with-param>          
            <xsl:with-param name="uniqueId">calendar-module</xsl:with-param>
            <xsl:with-param name="config">{
                "colorsMap": function() { return <xsl:apply-templates select="/calendar/colors"/> },
                "glyphs": function() { return <xsl:apply-templates select="/calendar/glyphs"/> },
                "resourceCalendar": function() { return <xsl:apply-templates select="/calendar/resourceCalendar"/> },
                "recurrenceTypes": function() { return <xsl:apply-templates select="/calendar/recurrenceTypes"/> },
            }</xsl:with-param>
        </xsl:call-template> 
    </xsl:template>

    <xsl:template match="resourceCalendar">
            <xsl:text>{</xsl:text>
	        <xsl:text>"id": "</xsl:text><xsl:value-of select="id"/><xsl:text>",</xsl:text>
	        <xsl:text>"title": "</xsl:text><xsl:value-of select="title"/><xsl:text>",</xsl:text>
	        <xsl:text>"color": "</xsl:text><xsl:value-of select="color"/><xsl:text>"</xsl:text>
            <xsl:text>}</xsl:text>
    </xsl:template>
    
    <xsl:template match="colors">
            <xsl:text>{</xsl:text>
            <xsl:text>colors: {</xsl:text>
            <xsl:for-each select="color">
                <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
                <xsl:call-template name="color" />
            </xsl:for-each>
            <xsl:text>}</xsl:text>
            <xsl:text>, resourceColor: {</xsl:text>
            <xsl:for-each select="resourceColor">
                <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
                <xsl:call-template name="color" />
            </xsl:for-each>
            <xsl:text>}</xsl:text>
            <xsl:text>}</xsl:text>
    </xsl:template>
    
    <xsl:template name="color">
        <xsl:value-of select="@id"/><xsl:text> :{</xsl:text>
        <xsl:text>"id": "</xsl:text><xsl:value-of select="@id"/><xsl:text>",</xsl:text>
        <xsl:text>"label": "</xsl:text><xsl:value-of select="label"/><xsl:text>",</xsl:text>
        <xsl:text>"border": "</xsl:text><xsl:value-of select="border"/><xsl:text>",</xsl:text>
        <xsl:text>"bg": "</xsl:text><xsl:value-of select="bg"/><xsl:text>",</xsl:text>
        <xsl:text>"fg": "</xsl:text><xsl:value-of select="fg"/><xsl:text>",</xsl:text>
        <xsl:text>"fgnobackground": "</xsl:text><xsl:value-of select="fgnobackground"/><xsl:text>"</xsl:text>
        <xsl:text>}</xsl:text>
    </xsl:template>
    
    <xsl:template match="recurrenceTypes">
        <xsl:text>[</xsl:text>
        <xsl:for-each select="recurrenceType">
            <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
            <xsl:text>{</xsl:text>
		    <xsl:text>"id": "</xsl:text><xsl:value-of select="recurrenceTypeName"/><xsl:text>",</xsl:text>
		    <xsl:text>"label": "</xsl:text><xsl:copy-of select="recurrenceTypeLabel/node()"/><xsl:text>"</xsl:text>
		    <xsl:text>}</xsl:text>
        </xsl:for-each>
        <xsl:text>]</xsl:text>
    </xsl:template>
    
    <xsl:template match="glyphs">
        <xsl:text>[</xsl:text>
        <xsl:for-each select="glyph">
            <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
            <xsl:text>[</xsl:text>
            <xsl:for-each select="alt">
            <xsl:if test="position()!=1"><xsl:text>,</xsl:text></xsl:if>
            <xsl:text>"</xsl:text><xsl:value-of select="current()"/><xsl:text>"</xsl:text>
            </xsl:for-each>
            <xsl:text>]</xsl:text>
        </xsl:for-each>
        <xsl:text>]</xsl:text>
    </xsl:template>
</xsl:stylesheet>
