<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="ametys">
                
    <xsl:template match="/">
        <html>
            <head>
                <script>
                    window.addEventListener(
                      "message",
                      (event) => {
                            document.title = event.data.document.title + " - " + event.data.projectName;
                            new DocsAPI.DocEditor("placeholder", event.data);
                      },
                      false
                    );                
                </script>
                <script type="text/javascript" src="{ametys:config('workspaces.onlyoffice.server.url')}/web-apps/apps/api/documents/api.js"/>
                <style>
                    html, body {
                        height: 100%;
                        padding: 0;
                        margin: 0;
                    }
                </style>
            </head>
            <body>
                <div id="placeholder"></div>
                <script>
                    console.info("Sending ready")
                    window.opener.postMessage("ready");
                </script>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
