/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget to select one or more project's keywords.<br>
 * See {@link Ametys.plugins.workspaces.project.helper.ChooseTag}<br>
 * 
 * This widget is registered for fields of type Ametys.form.WidgetManager#TYPE_STRING.
 */
Ext.define('Ametys.plugins.workspaces.project.widget.ProjectKeyword', {
    extend : 'Ametys.plugins.workspaces.project.widget.AbstractProjectTag',
    
    xtype: 'edition.project-keyword',
    
    url: 'keywords.json',
    
    buttonIconCls: 'ametysicon-keyword3',
    
    tagModel:'Ametys.plugins.workspaces.project.keyword.KeywordNode',
    tagsDAO: "org.ametys.plugins.workspaces.keywords.KeywordsDAO",
    
    emptyText: "{{i18n PLUGINS_WORKSPACES_WIDGET_KEYWORDS_NO_KEYWORD}}",
    buttonTooltipText : "{{i18n PLUGINS_WORKSPACES_WIDGET_KEYWORDS_ADD_BUTTON_TOOLTIP}}",
    deleteTooltipText : "{{i18n PLUGINS_WORKSPACES_WIDGET_KEYWORDS_DELETE_BUTTON_TOOLTIP}}",
    dialogTitle: "{{i18n PLUGINS_WORKSPACES_WIDGET_KEYWORDS_CHOOSE_DIALOG_TITLE}}",
    dialogHelpMsg: "{{i18n PLUGINS_WORKSPACES_WIDGET_KEYWORDS_CHOOSE_DIALOG_HINT}}",
    
    constructor: function (config)
    {
        config.url = config.url || 'keywords.json';
        
        this.callParent(arguments);
    }
    
})