/* 
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

jQuery(document).ready(function() {
    // Create the tooltip object
    jQuery("body").append("<div id='ametys-tooltip'></div>")
    var tooltip = jQuery("#ametys-tooltip");
    tooltip.on('transitionend', function() {
        // really hide tooltip when opacity is finally 0
        if (!tooltip.is(".ametys-tooltip-show"))
        {
            tooltip.hide();
        }
    })
    
    jQuery(document).on("mousemove", function(e) {
        var $tooltipTarget = jQuery(e.target).closest("[data-ametys-tooltip]");
        if ($tooltipTarget.length
            && (!$tooltipTarget.is(".ametys-truncate-1,.ametys-truncate-2,.ametys-truncate-3,.ametys-truncate-4,.ametys-truncate-5,.ametys-truncate-6,.ametys-truncate-7,.ametys-truncate-8,.ametys-truncate-9,.ametys-truncate-10")
                || ($tooltipTarget[0].offsetWidth < $tooltipTarget[0].scrollWidth
                    || $tooltipTarget[0].offsetHeight < $tooltipTarget[0].scrollHeight)))
        {
            if ($tooltipTarget.data("ametys-tooltip-type") == "action")
            {
                tooltip.addClass("ametys-tooltip-type-action")
            }
            else
            {
                tooltip.removeClass("ametys-tooltip-type-action")
            }
            
            if ($tooltipTarget.data("ametys-tooltip-max-width"))
            {
                tooltip.css('max-width', $tooltipTarget.data("ametys-tooltip-max-width"))
            }
            else
            {
                tooltip.css('max-width', "");
            }
            
            var $window = jQuery(window);
            var windowSize = {
                left: $window.scrollLeft(),
                top: $window.scrollTop(),
                width: $window.innerWidth(),
                height: $window.innerHeight()
            };
            
            // bring tooltip back to top left, to have enought space to fill text and compute size correctly
            tooltip.css('top', 0)
                    .css('left', 0);
                    
            tooltip.html($tooltipTarget.attr("data-ametys-tooltip"));
            
            var tooltipSize = {
                height: tooltip.outerHeight(),
                width: tooltip.outerWidth()
            };
            
            var $truncateTarget = $tooltipTarget.closest(".ametys-truncate-1,.ametys-truncate-2,.ametys-truncate-3,.ametys-truncate-4,.ametys-truncate-5,.ametys-truncate-6,.ametys-truncate-7,.ametys-truncate-8,.ametys-truncate-9,.ametys-truncate-10");
            if (!$truncateTarget.length)
            {
                $truncateTarget = $tooltipTarget;
            }
            var position = $truncateTarget.offset();
            
            var offsetX = $tooltipTarget.data("ametys-tooltip-offset-x") ? $tooltipTarget.data("ametys-tooltip-offset-x") : 0;
            var offsetY = $tooltipTarget.data("ametys-tooltip-offset-y") ? $tooltipTarget.data("ametys-tooltip-offset-y") : 0;
            
            var top = position.top - tooltipSize.height - 8 + parseInt(offsetY);
            var left = position.left + $truncateTarget.outerWidth() / 2 - tooltipSize.width / 2 + parseInt(offsetX);
            
            // Ensure on screen
            left = Math.min(left, windowSize.left + windowSize.width - tooltipSize.width);
            left = Math.max(left, windowSize.left);
            top = Math.min(top, windowSize.top + windowSize.height - tooltipSize.height);
            top = Math.max(top, windowSize.top);
            
            tooltip.css('top', top)
                    .css('left', left);
            tooltip.show();
            tooltip.addClass("ametys-tooltip-show");
        }
        else
        {
            tooltip.removeClass("ametys-tooltip-show");
        }
    });
})
