<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:avatar="org.ametys.plugins.core.ui.user.ProfileImageResolverHelper">
                              
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    
    <!-- 
    <item type="content">
        <title>foo</title>
        <date>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</date>
        <datetime>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</datetime>
        <content>Lorem ipsum sit amet</content>
        <author>
            <login/>
            <populationId/>
            <fullname/>
            <firstname/>
            <email/>
            ...
        </author>
        <tags>
            <tag>tag1</tag>
            <tag>tag2</tag>
        </tags>
        <images>
            <image>
                <src/>
                <alt/>
            </image>
            <image>
                <src/>
                <alt/>
            </image>
        </image>
        <comments>
            <comment>
                <id>
                <datetime>
                <author>
                <content>
                <sub-comments>
                    <comment>
                        <id>
                        <datetime>
                        <author>
                        <content>
                    </comment>
                </sub-comment>
            </comment>
        </comments>
    <item>
     -->
     
    <!-- Overriden to change padding -->
    <xsl:template match="item[@type='content']">
        <xsl:param name="width" select="$max-width - 60"/>
        <xsl:param name="padding-top">20</xsl:param>
        <xsl:param name="padding-bottom">5</xsl:param>
        <xsl:param name="padding-left">20</xsl:param>
        <xsl:param name="padding-right">20</xsl:param>
        
        <xsl:variable name="isLast" select="position() = last()"/>
        
        <xsl:apply-templates select="." mode="wrapper">
            <xsl:with-param name="width" select="$width"/>
            <xsl:with-param name="padding-top" select="$padding-top"/>
            <xsl:with-param name="padding-bottom" select="$padding-bottom"/>
            <xsl:with-param name="padding-left" select="$padding-left"/>
            <xsl:with-param name="padding-right" select="$padding-right"/>
            <xsl:with-param name="isLast" select="$isLast"/>
        </xsl:apply-templates>
        
        <xsl:apply-templates select="." mode="item-additional-content">
            <xsl:with-param name="isLast" select="$isLast"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="item[@type='content']" mode="item-content">
        <table> 
            <xsl:call-template name="table-layout-attributes"/>
            <tbody>
                <tr>
                    <td>
                        <xsl:call-template name="td-layout-attributes"/>
                        <table>
                            <xsl:call-template name="table-layout-attributes"/>
                            <tbody>
                                <!-- First group with the icon, the title and the data -->
                                <tr>
                                    <!-- User avatar -->
                                    <xsl:apply-templates select="." mode="content-author"/>
                                    <!-- Title and date -->
                                    <td>
                                        <xsl:call-template name="td-layout-attributes"/>
                                        <xsl:apply-templates select="." mode="item-title"/>
                                        <xsl:call-template name="table-vertical-spacer">
                                            <xsl:with-param name="height">0</xsl:with-param>
                                        </xsl:call-template>
                                        <xsl:apply-templates select="." mode="content-date"/>
                                        <xsl:apply-templates select="." mode="content-datetime"/>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
                
                <!-- Content -->
                <xsl:apply-templates select="." mode="content-details">
                    <xsl:with-param name="isLast" select="position() = last()"/>
                </xsl:apply-templates>
            </tbody>
        </table>
    </xsl:template>
    
    <!-- no separator for content items -->
    <xsl:template match="item[@type='content']" mode="item-separator-style">
        <xsl:choose>
            <xsl:when test="images/image or comments/comment"></xsl:when>
            <xsl:otherwise><xsl:text>border-bottom: 2px solid </xsl:text><xsl:value-of select="$separator-color"/><xsl:text>;</xsl:text></xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template match="item[@type='content']" mode="item-additional-content">
        <xsl:param name="isLast"/>
        
        <xsl:apply-templates select="." mode="content-images">
            <xsl:with-param name="isLast" select="$isLast"/>
        </xsl:apply-templates>
        
        <!-- We stick the comment inside the element -->
        <xsl:apply-templates select="comments/comment"/>
    </xsl:template>
    
    <xsl:template match="item" mode="content-author">
        <td width="42px" style="padding: 0px; direction: ltr; font-size: 0px; word-break: break-word;" valign="top">
            <div style="width: 42px; height: 42px; display: inline-block;">
                <xsl:variable name="lang"><xsl:value-of select="ametys:lang()"/></xsl:variable>
                <img width="42" height="42" src="{avatar:resolveAsBase64(author/login, author/populationId, 42, $lang)}" alt="{author/fullname}" style="display: block; border: solid 3px #fff; border-radius: 50%; outline: none; text-decoration: none;"/>
            </div>
        </td>
        <!-- right margin -->
        <xsl:call-template name="row-horizontal-spacer">
            <xsl:with-param name="width">12</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="item" mode="content-date">
        <xsl:if test="date">
            <xsl:variable name="i18nparam"><param/></xsl:variable>
            <xsl:variable name="date-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_CONTENT_DATE_FORMAT', $lang, i18nparam)"></xsl:variable>
            
            <div style="font-style: italic; font-size: 12px; font-family: {$font-family}; color: {$text-color-dark}; font-weight:300;">
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}"><xsl:value-of select="date"/></i18n:date>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="content-datetime">
        <xsl:if test="datetime">
            <xsl:variable name="i18nparam"><param/></xsl:variable>
            <xsl:variable name="datetime-format" select="ametys:translate('plugin.workspaces:PROJECT_MAIL_NOTIFICATION_CONTENT_DATE_TIME_FORMAT', $lang, i18nparam)"></xsl:variable>
            
            <div style="font-style: italic; font-size: 12px; font-family: {$font-family}; color: {$text-color-dark}; font-weight:300;">
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$datetime-format}"><xsl:value-of select="datetime"/></i18n:date>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="content-details">
        <tr>
            <td>
                <xsl:call-template name="td-layout-attributes"/>
                <table>
                    <xsl:call-template name="table-layout-attributes"/>
                    <tbody>
                        <tr>
                            <td colspan="2">
                                <xsl:call-template name="td-layout-attributes"/>
                                <xsl:call-template name="table-vertical-spacer">
                                    <xsl:with-param name="height">15</xsl:with-param>
                                </xsl:call-template>
                                <div>
                                    <xsl:call-template name="text-style"/>
                                    <xsl:call-template name="text.nl2br">
                                        <xsl:with-param name="input" select="content"/>
                                    </xsl:call-template>
                                </div>
                                <xsl:apply-templates select="." mode="content-tags"/>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </xsl:template>
    
    <xsl:template match="item" mode="content-tags">
        <xsl:if test="tags/tag">
            <xsl:call-template name="table-vertical-spacer">
                <xsl:with-param name="height">10</xsl:with-param>
            </xsl:call-template>
            
            <div style="font-weight: 600; font-size: 12px; color: {$text-color-dark}; font-family: {$font-family}; line-height: 1.4">
                <xsl:for-each select="tags/tag">
                    <span style="padding: 5px 8px; background-color: {$bg-highlight}">#&#160;<xsl:value-of select="."/></span>
                    <xsl:if test="position() != last()">&#160;&#160;</xsl:if>
                </xsl:for-each>  
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="item" mode="content-images">
        <xsl:param name="isLast"/>
        
        <xsl:if test="images/image">
            <xsl:call-template name="images-container">
                <xsl:with-param name="width" select="$max-width - 60"/>
                <xsl:with-param name="srcImage1" select="images/image[position()=1]/src"/>
                <xsl:with-param name="altImage1" select="images/image[position()=1]/alt"/>
                <xsl:with-param name="srcImage2" select="images/image[position()=2]/src"/>
                <xsl:with-param name="altImage2" select="images/image[position()=2]/alt"/>
                <xsl:with-param name="withBorder" select="not($isLast) and not(comments/comment)"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>