/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { createApp } from 'vue'
import { createVuetify } from 'vuetify'

import { createPinia } from 'pinia'

function _rootCategories(categories, parentCategory)
{
    var catetegoriesMap = {};

    for (var c in categories)
    {
        var category = categories[c];

        catetegoriesMap[category.name] = parentCategory || category;

        if (categories[c].children)
        {
            var childrenCatetegoriesMap = _rootCategories(categories[c].children, catetegoriesMap[category.name]);
            catetegoriesMap = { ...catetegoriesMap, ...childrenCatetegoriesMap};
        }
    }

    return catetegoriesMap;
}

import { fa } from 'vuetify/iconsets/fa'
import { md } from 'vuetify/iconsets/md'

// Vue base component
import App from '@/CatalogModule.vue';

// Init App
window['vue-catalog-run'] = function (selector, config) {
    
    const vuetify = createVuetify({
        icons: {
            defaultSet: 'fa',
            sets: {
              fa,
              md
            },
        },
    });
    
    const app = createApp(App, config);
    app.config.globalProperties.$rootCategories = _rootCategories(config.categories())
    const pinia = createPinia()
    pinia.use(({ store }) => {
      store.$rootCategories = app.config.globalProperties.$rootCategories;
    });
    app.use(pinia);
    app.use(vuetify);

    app.mount(selector);
};
