/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import { createApp } from 'vue'
import { createVuetify } from 'vuetify'
import VueSmoothScroll from 'vue3-smooth-scroll'

// Vue base component
import App from '@/FileManagerModule.vue';

import { fa } from 'vuetify/iconsets/fa'
import { md } from 'vuetify/iconsets/md'

// Translations provided by Vuetify
import { fr, en } from 'vuetify/locale'
import { createPinia } from 'pinia'

// Init App
window['vue-file-manager-run'] = function (selector, config) {
    const vuetify = createVuetify({
        icons: {
            defaultSet: 'fa',
            sets: {
              fa,
              md
            },
        },
        locale: {
            messages: {
                fr: fr,
                en: en
            },
        },
    });
    
    const app = createApp(App);
    const pinia = createPinia()
    app.use(pinia);
    app.use(vuetify);
    app.use(VueSmoothScroll);
    
    app.config.globalProperties.$onlyOfficeEnabled = config.onlyOfficeEnabled;
    app.config.globalProperties.$onlyOfficeEditionEnabled = config.onlyOfficeEditionEnabled;
    app.config.globalProperties.$msOfficeEnabled = config.msOfficeEnabled;
    

    app.mount(selector);
};
