/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import { createApp } from 'vue';
import { createVuetify } from 'vuetify';
import VueSmoothScroll from 'vue3-smooth-scroll';
import { createPinia } from 'pinia'

import Mixin from '@/mixins/global';
import PortalVue from 'portal-vue';

import { fa } from 'vuetify/iconsets/fa'
import { md } from 'vuetify/iconsets/md'

// Translations provided by Vuetify
import { fr, en } from 'vuetify/locale'

// Vue base component
import App from '@/ForumModule.vue';
import DiscussionsIcon from '@/components/icons/Discussions.vue';
import QuestionsIcon from '@/components/icons/Questions.vue';
import MoreIcon from '@/components/icons/More.vue';
import PdfIcon from '@/components/icons/Pdf.vue';
import GridModeIcon from '@/components/icons/GridMode.vue';
import ListModeIcon from '@/components/icons/ListMode.vue';
import CheckTickIcon from '@/components/icons/CheckTick.vue';
import AllThreads from '@/components/icons/AllThreads.vue';
import AllThreadsGrey from '@/components/icons/AllThreadsGrey.vue';

// Init App
window['vue-forum-run'] = function (selector, config) {
    

    const vuetify = createVuetify({
        icons: {
            defaultSet: 'fa',
            sets: {
              fa,
              md
            },
            aliases: {
                discussion: DiscussionsIcon,
                question: QuestionsIcon,
                DISCUSSION: DiscussionsIcon,
                QUESTION: QuestionsIcon,
                more: MoreIcon,
                pdf: PdfIcon,
                gridMode: GridModeIcon,
                listMode: ListModeIcon,
                checkTick: CheckTickIcon,
                allThreads: AllThreads ,
                allThreadsGrey: AllThreadsGrey
            },
        },
        locale: {
            messages: {
                fr: fr,
                en: en
            },
        },
    });


    const app = createApp(App);

    const pinia = createPinia()
    app.use(pinia);
    app.use(vuetify);
    app.use(VueSmoothScroll);
    app.use(PortalVue);
    app.config.globalProperties.$threadCategories = config.threadCategories();

    app.mixin(Mixin);

    app.mount(selector);
};
