/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import { defineStore } from 'pinia'
import { callMethod } from '@common/helper/ServerCommHelper.js';

/**
 * Pinia store for handling projects of the current user
 */
export const useUserProjectsStore = defineStore('userProjects', {
    state: () => ({
        userProjects: [] // The list of projects available for current user
    }),
    actions:
    {
        /**
         * Load the list of projects available for current user
         */
        async loadUserProjects()
        {
            const projects = await callMethod({
                role: 'org.ametys.plugins.workspaces.project.ProjectManager',
                methodName: 'getUserProjectsData'
            });

            this.userProjects = projects;
        }
    }
})
