/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;

import org.ametys.plugins.explorer.ObservationConstants;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType.ResourceReference;

/**
 * {@link ActivityType} implementation for the renaming of a resource 
 */
public class ResourceCreatedOrUpdatedActivityType extends DocumentsActivityType
{
    @SuppressWarnings("unchecked")
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        
        // File data
        Set<String> resourceIds = new HashSet<>();
        if (parameters.containsKey(ObservationConstants.ARGS_RESOURCES))
        {
            resourceIds.addAll(((Map<String, Object>) parameters.get(ObservationConstants.ARGS_RESOURCES)).keySet());
        }
        else
        {
            resourceIds.add((String) parameters.get(ObservationConstants.ARGS_ID));
        }
        
        ResourceReference[] references = new ResourceReference[resourceIds.size()];
        int i = 0;
        for (String resourceId : resourceIds)
        {
            JCRResource resource = (JCRResource) _ametysObjectResolver.resolveById(resourceId);
            Node resourceNode = resource.getNode();
            
            VersionManager versionManager = resourceNode.getSession().getWorkspace().getVersionManager();
            Version baseVersion = versionManager.getBaseVersion(resourceNode.getPath());
            
            // Store a reference to the version of the node instead of on the node itself
            references[i] = new ResourceReference(resourceId, resource.getName(), null, resource.getMimeType(), baseVersion.getName());
            i++;
        }
        activity.setValue(DocumentsActivityType.FILES_DATA_NAME, references);
    }
}
