/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.Map;

import javax.jcr.RepositoryException;

import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;

/**
 * {@link ActivityType} implementation for projects-related activities
 */
public abstract class AbstractProjectsActivityType extends AbstractWorkspacesActivityType
{
    /** Constant for activity's category */
    public static final String EVENT_CATEGORY_PROJECTS = "projects";
    
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        
        activity.setValue(PROJECT_CATEGORY, EVENT_CATEGORY_PROJECTS);
    }
}
