/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project;

/**
 * Project constants.
 */
public interface ProjectConstants
{
    /** Project workspace page template. */
    public static final String PROJECT_TEMPLATE = "project";
    
    /** Project workspace page template for the about module. */
    public static final String ABOUT_TEMPLATE = "project-about";
    
    /** Project workspace page template for the minisite module. */
    public static final String MINISITE_TEMPLATE = "project-minisite";
    
    /** Calendar module service identifier */
    public static final String CALENDAR_MODULE_SERVICE_ID = "org.ametys.plugins.workspaces.module.Calendar";
    
    /** Right ID to create private project in the back office */
    public static final String RIGHT_PROJECT_CREATE_PRIVATE = "Plugins_Workspaces_Rights_Project_Create_Private";

    /** Right ID to create public project with moderation in the back office */
    public static final String RIGHT_PROJECT_CREATE_PUBLIC_MODERATED = "Plugins_Workspaces_Rights_Project_Create_Public_Moderated";

    /** Right ID to create public project opened in the back office */
    public static final String RIGHT_PROJECT_CREATE_PUBLIC_OPENED = "Plugins_Workspaces_Rights_Project_Create_Public_Opened";
    
    /** Right ID to edit project in the back office */
    public static final String RIGHT_PROJECT_EDIT = "Plugins_Workspaces_Rights_Project_Edit";

    /** Right ID to delete project in the back office */
    public static final String RIGHT_PROJECT_DELETE = "Plugins_Workspaces_Rights_Project_Delete";
    
    /** Right ID to add a tag */
    public static final String RIGHT_PROJECT_ADD_TAG = "Plugins_Workspaces_Rights_Project_Add_Tag";
    
    /** Right ID to delete a tag */
    public static final String RIGHT_PROJECT_DELETE_TAG = "Plugins_Workspaces_Rights_Project_Delete_Tag";
    
    /** Right ID to manager project tags */
    public static final String RIGHT_PROJECT_HANDLE_TAGS = "Workspace_Rights_Tags_HandleTag";

    /** Right ID to manager project keywords (not modules keywords) */
    public static final String RIGHT_PROJECT_HANDLE_PROJECTKEYWORDS = "Workspace_Rights_Keywords_HandleKeyword";
    
    /** Right ID to manage category */
    public static final String RIGHTS_PROJECT_HANDLE_CATEGORY = "Workspace_Rights_Categories_HandleCategory";
    
    /** Project Right to add a member to a project */
    public static final String RIGHT_PROJECT_ADD_MEMBER = "Plugins_Workspaces_Rights_Service_Module_Members_Add";
    
    /** Project Right to remove a member from the project */
    public static final String RIGHT_PROJECT_REMOVE_MEMBER = "Plugins_Workspaces_Rights_Service_Module_Members_Remove";


}
