/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.actions;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;

/**
 * Action when accepting a member clicking on the email
 */
public class AddMemberAction extends ServiceableAction
{
    private ProjectMemberManager _projectMemberManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _projectMemberManager = (ProjectMemberManager) smanager.lookup(ProjectMemberManager.ROLE);
    }
    
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        String user = source;
        String projectName = parameters.getParameter("project");
        
        Request request = ObjectModelHelper.getRequest(objectModel);
        String forcedWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace(request);
        try
        {
            RequestAttributeWorkspaceSelector.setForcedWorkspace(request, "default");
            
            Map<String, Object> result = _projectMemberManager.addMember(projectName, user, "user");
            
            if ((boolean) result.get("success"))
            {
                return EMPTY_MAP;
            }
            else
            {
                throw new IllegalStateException("USer " + user + " was not added to project " + projectName + ": " + result.get("message"));
            }
        }
        finally
        {
            RequestAttributeWorkspaceSelector.setForcedWorkspace(request, forcedWorkspace);
        }
    }

}
